/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.netflix.spinnaker.keel.persistence.AgentLockRepository;
import com.netflix.spinnaker.keel.persistence.metamodel.Tables;
import com.netflix.spinnaker.keel.scheduled.ScheduledAgent;
import com.netflix.spinnaker.keel.sql.RetryCategory;
import com.netflix.spinnaker.keel.sql.SqlRetry;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlAgentLockRepository;", "Lcom/netflix/spinnaker/keel/persistence/AgentLockRepository;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "agents", "", "Lcom/netflix/spinnaker/keel/scheduled/ScheduledAgent;", "sqlRetry", "Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "(Lorg/jooq/DSLContext;Ljava/time/Clock;Ljava/util/List;Lcom/netflix/spinnaker/keel/sql/SqlRetry;)V", "getAgents", "()Ljava/util/List;", "getLockedAgents", "", "tryAcquireLock", "", "agentName", "lockTimeoutSeconds", "", "keel-sql"})
public final class SqlAgentLockRepository
implements AgentLockRepository {
    private final DSLContext jooq;
    private final Clock clock;
    @NotNull
    private final List<ScheduledAgent> agents;
    private final SqlRetry sqlRetry;

    public boolean tryAcquireLock(@NotNull String agentName, long lockTimeoutSeconds) {
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        Instant now = this.clock.instant();
        int changed2 = ((Number)this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, agentName, now, lockTimeoutSeconds){
            final /* synthetic */ SqlAgentLockRepository this$0;
            final /* synthetic */ String $agentName;
            final /* synthetic */ Instant $now;
            final /* synthetic */ long $lockTimeoutSeconds;

            public final int invoke() {
                return SqlAgentLockRepository.access$getJooq$p(this.this$0).insertInto((Table)Tables.AGENT_LOCK).set((Field)Tables.AGENT_LOCK.LOCK_NAME, (Object)this.$agentName).set((Field)Tables.AGENT_LOCK.EXPIRY, (Object)this.$now.plusSeconds(this.$lockTimeoutSeconds)).onDuplicateKeyIgnore().execute();
            }
            {
                this.this$0 = sqlAgentLockRepository;
                this.$agentName = string;
                this.$now = instant;
                this.$lockTimeoutSeconds = l;
                super(0);
            }
        })).intValue();
        if (changed2 == 0) {
            changed2 = ((Number)this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, now, lockTimeoutSeconds, agentName){
                final /* synthetic */ SqlAgentLockRepository this$0;
                final /* synthetic */ Instant $now;
                final /* synthetic */ long $lockTimeoutSeconds;
                final /* synthetic */ String $agentName;

                public final int invoke() {
                    return SqlAgentLockRepository.access$getJooq$p(this.this$0).update((Table)Tables.AGENT_LOCK).set((Field)Tables.AGENT_LOCK.EXPIRY, (Object)this.$now.plusSeconds(this.$lockTimeoutSeconds)).where(new Condition[]{Tables.AGENT_LOCK.LOCK_NAME.eq((Object)this.$agentName), Tables.AGENT_LOCK.EXPIRY.lt((Object)this.$now)}).execute();
                }
                {
                    this.this$0 = sqlAgentLockRepository;
                    this.$now = instant;
                    this.$lockTimeoutSeconds = l;
                    this.$agentName = string;
                    super(0);
                }
            })).intValue();
        }
        return changed2 == 1;
    }

    @NotNull
    public List<String> getLockedAgents() {
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<String>>(this){
            final /* synthetic */ SqlAgentLockRepository this$0;

            public final List<String> invoke() {
                return SqlAgentLockRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.AGENT_LOCK.LOCK_NAME).from((TableLike)Tables.AGENT_LOCK).fetch((Field)Tables.AGENT_LOCK.LOCK_NAME);
            }
            {
                this.this$0 = sqlAgentLockRepository;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026ENT_LOCK.LOCK_NAME)\n    }");
        return (List)t;
    }

    @NotNull
    public List<ScheduledAgent> getAgents() {
        return this.agents;
    }

    public SqlAgentLockRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull List<? extends ScheduledAgent> agents, @NotNull SqlRetry sqlRetry) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(agents, (String)"agents");
        Intrinsics.checkNotNullParameter((Object)sqlRetry, (String)"sqlRetry");
        this.jooq = jooq;
        this.clock = clock;
        this.agents = agents;
        this.sqlRetry = sqlRetry;
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlAgentLockRepository $this) {
        return $this.jooq;
    }
}

