/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.jooq.LocalDateTimeToInstantConverter;
import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.Keys;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.Resource;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.ResourceVersionRecord;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row4;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class ResourceVersion
extends TableImpl<ResourceVersionRecord> {
    private static final long serialVersionUID = -2063247620L;
    public static final ResourceVersion RESOURCE_VERSION = new ResourceVersion();
    public final TableField<ResourceVersionRecord, String> RESOURCE_UID = ResourceVersion.createField((Name)DSL.name((String)"resource_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<ResourceVersionRecord, Integer> VERSION = ResourceVersion.createField((Name)DSL.name((String)"version"), (DataType)SQLDataType.INTEGER.nullable(false).defaultValue((Field)DSL.inline((Object)"1", (DataType)SQLDataType.INTEGER)), (Table)this, (String)"");
    public final TableField<ResourceVersionRecord, Instant> CREATED_AT = ResourceVersion.createField((Name)DSL.name((String)"created_at"), (DataType)SQLDataType.LOCALDATETIME, (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());
    public final TableField<ResourceVersionRecord, String> SPEC = ResourceVersion.createField((Name)DSL.name((String)"spec"), (DataType)SQLDataType.LONGVARCHAR.nullable(false), (Table)this, (String)"");

    public Class<ResourceVersionRecord> getRecordType() {
        return ResourceVersionRecord.class;
    }

    public ResourceVersion() {
        this(DSL.name((String)"resource_version"), null);
    }

    public ResourceVersion(String alias) {
        this(DSL.name((String)alias), (Table<ResourceVersionRecord>)RESOURCE_VERSION);
    }

    public ResourceVersion(Name alias) {
        this(alias, (Table<ResourceVersionRecord>)RESOURCE_VERSION);
    }

    private ResourceVersion(Name alias, Table<ResourceVersionRecord> aliased) {
        this(alias, aliased, null);
    }

    private ResourceVersion(Name alias, Table<ResourceVersionRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public <O extends Record> ResourceVersion(Table<O> child, ForeignKey<O, ResourceVersionRecord> key) {
        super(child, key, (Table)RESOURCE_VERSION);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public UniqueKey<ResourceVersionRecord> getPrimaryKey() {
        return Keys.KEY_RESOURCE_VERSION_PRIMARY;
    }

    public List<UniqueKey<ResourceVersionRecord>> getKeys() {
        return Arrays.asList(Keys.KEY_RESOURCE_VERSION_PRIMARY);
    }

    public List<ForeignKey<ResourceVersionRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_RESOURCE_VERSION_RESOURCE);
    }

    public Resource resource() {
        return new Resource(this, Keys.FK_RESOURCE_VERSION_RESOURCE);
    }

    public ResourceVersion as(String alias) {
        return new ResourceVersion(DSL.name((String)alias), (Table<ResourceVersionRecord>)this);
    }

    public ResourceVersion as(Name alias) {
        return new ResourceVersion(alias, (Table<ResourceVersionRecord>)this);
    }

    public ResourceVersion rename(String name) {
        return new ResourceVersion(DSL.name((String)name), null);
    }

    public ResourceVersion rename(Name name) {
        return new ResourceVersion(name, null);
    }

    public Row4<String, Integer, Instant, String> fieldsRow() {
        return (Row4)super.fieldsRow();
    }
}

