/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.Keys;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.DeliveryConfig;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.Environment;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.PreviewEnvironmentRecord;
import java.util.Arrays;
import java.util.List;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row5;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class PreviewEnvironment
extends TableImpl<PreviewEnvironmentRecord> {
    private static final long serialVersionUID = -243048437L;
    public static final PreviewEnvironment PREVIEW_ENVIRONMENT = new PreviewEnvironment();
    public final TableField<PreviewEnvironmentRecord, String> DELIVERY_CONFIG_UID = PreviewEnvironment.createField((Name)DSL.name((String)"delivery_config_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<PreviewEnvironmentRecord, String> BASE_ENVIRONMENT_UID = PreviewEnvironment.createField((Name)DSL.name((String)"base_environment_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<PreviewEnvironmentRecord, String> BRANCH_FILTER = PreviewEnvironment.createField((Name)DSL.name((String)"branch_filter"), (DataType)SQLDataType.LONGVARCHAR.nullable(false), (Table)this, (String)"");
    public final TableField<PreviewEnvironmentRecord, String> VERIFICATIONS = PreviewEnvironment.createField((Name)DSL.name((String)"verifications"), (DataType)SQLDataType.LONGVARCHAR, (Table)this, (String)"");
    public final TableField<PreviewEnvironmentRecord, String> NOTIFICATIONS = PreviewEnvironment.createField((Name)DSL.name((String)"notifications"), (DataType)SQLDataType.LONGVARCHAR, (Table)this, (String)"");

    public Class<PreviewEnvironmentRecord> getRecordType() {
        return PreviewEnvironmentRecord.class;
    }

    public PreviewEnvironment() {
        this(DSL.name((String)"preview_environment"), null);
    }

    public PreviewEnvironment(String alias) {
        this(DSL.name((String)alias), (Table<PreviewEnvironmentRecord>)PREVIEW_ENVIRONMENT);
    }

    public PreviewEnvironment(Name alias) {
        this(alias, (Table<PreviewEnvironmentRecord>)PREVIEW_ENVIRONMENT);
    }

    private PreviewEnvironment(Name alias, Table<PreviewEnvironmentRecord> aliased) {
        this(alias, aliased, null);
    }

    private PreviewEnvironment(Name alias, Table<PreviewEnvironmentRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public <O extends Record> PreviewEnvironment(Table<O> child, ForeignKey<O, PreviewEnvironmentRecord> key) {
        super(child, key, (Table)PREVIEW_ENVIRONMENT);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public UniqueKey<PreviewEnvironmentRecord> getPrimaryKey() {
        return Keys.KEY_PREVIEW_ENVIRONMENT_PRIMARY;
    }

    public List<UniqueKey<PreviewEnvironmentRecord>> getKeys() {
        return Arrays.asList(Keys.KEY_PREVIEW_ENVIRONMENT_PRIMARY);
    }

    public List<ForeignKey<PreviewEnvironmentRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_PREVIEW_ENVIRONMENT_DELIVERY_CONFIG, Keys.FK_PREVIEW_ENVIRONMENT_ENVIRONMENT);
    }

    public DeliveryConfig deliveryConfig() {
        return new DeliveryConfig(this, Keys.FK_PREVIEW_ENVIRONMENT_DELIVERY_CONFIG);
    }

    public Environment environment() {
        return new Environment(this, Keys.FK_PREVIEW_ENVIRONMENT_ENVIRONMENT);
    }

    public PreviewEnvironment as(String alias) {
        return new PreviewEnvironment(DSL.name((String)alias), (Table<PreviewEnvironmentRecord>)this);
    }

    public PreviewEnvironment as(Name alias) {
        return new PreviewEnvironment(alias, (Table<PreviewEnvironmentRecord>)this);
    }

    public PreviewEnvironment rename(String name) {
        return new PreviewEnvironment(DSL.name((String)name), null);
    }

    public PreviewEnvironment rename(Name name) {
        return new PreviewEnvironment(name, null);
    }

    public Row5<String, String, String, String, String> fieldsRow() {
        return (Row5)super.fieldsRow();
    }
}

