/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.LatestEnvironmentRecord;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row9;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class LatestEnvironment
extends TableImpl<LatestEnvironmentRecord> {
    private static final long serialVersionUID = 1160352771L;
    public static final LatestEnvironment LATEST_ENVIRONMENT = new LatestEnvironment();
    public final TableField<LatestEnvironmentRecord, String> UID = LatestEnvironment.createField((Name)DSL.name((String)"uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<LatestEnvironmentRecord, String> DELIVERY_CONFIG_UID = LatestEnvironment.createField((Name)DSL.name((String)"delivery_config_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<LatestEnvironmentRecord, String> NAME = LatestEnvironment.createField((Name)DSL.name((String)"name"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<LatestEnvironmentRecord, Integer> VERSION = LatestEnvironment.createField((Name)DSL.name((String)"version"), (DataType)SQLDataType.INTEGER.nullable(false).defaultValue((Field)DSL.inline((Object)"1", (DataType)SQLDataType.INTEGER)), (Table)this, (String)"");
    public final TableField<LatestEnvironmentRecord, Boolean> IS_PREVIEW = LatestEnvironment.createField((Name)DSL.name((String)"is_preview"), (DataType)SQLDataType.BIT.nullable(false).defaultValue((Field)DSL.inline((Object)"b'0'", (DataType)SQLDataType.BIT)), (Table)this, (String)"");
    public final TableField<LatestEnvironmentRecord, String> CONSTRAINTS = LatestEnvironment.createField((Name)DSL.name((String)"constraints"), (DataType)SQLDataType.LONGVARCHAR.nullable(false), (Table)this, (String)"");
    public final TableField<LatestEnvironmentRecord, String> NOTIFICATIONS = LatestEnvironment.createField((Name)DSL.name((String)"notifications"), (DataType)SQLDataType.LONGVARCHAR.nullable(false), (Table)this, (String)"");
    public final TableField<LatestEnvironmentRecord, String> VERIFICATIONS = LatestEnvironment.createField((Name)DSL.name((String)"verifications"), (DataType)SQLDataType.LONGVARCHAR.nullable(false), (Table)this, (String)"");
    public final TableField<LatestEnvironmentRecord, String> POST_DEPLOY_ACTIONS = LatestEnvironment.createField((Name)DSL.name((String)"post_deploy_actions"), (DataType)SQLDataType.LONGVARCHAR.nullable(false), (Table)this, (String)"");

    public Class<LatestEnvironmentRecord> getRecordType() {
        return LatestEnvironmentRecord.class;
    }

    public LatestEnvironment() {
        this(DSL.name((String)"latest_environment"), null);
    }

    public LatestEnvironment(String alias) {
        this(DSL.name((String)alias), (Table<LatestEnvironmentRecord>)LATEST_ENVIRONMENT);
    }

    public LatestEnvironment(Name alias) {
        this(alias, (Table<LatestEnvironmentRecord>)LATEST_ENVIRONMENT);
    }

    private LatestEnvironment(Name alias, Table<LatestEnvironmentRecord> aliased) {
        this(alias, aliased, null);
    }

    private LatestEnvironment(Name alias, Table<LatestEnvironmentRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)"VIEW"), TableOptions.view((String)"create view `latest_environment` as select `keel`.`environment`.`uid` AS `uid`,`keel`.`environment`.`delivery_config_uid` AS `delivery_config_uid`,`keel`.`environment`.`name` AS `name`,`keel`.`environment_version`.`version` AS `version`,`keel`.`environment`.`is_preview` AS `is_preview`,`keel`.`environment`.`constraints` AS `constraints`,`keel`.`environment`.`notifications` AS `notifications`,`keel`.`environment`.`verifications` AS `verifications`,`keel`.`environment`.`post_deploy_actions` AS `post_deploy_actions` from (`keel`.`environment` join `keel`.`environment_version` on(((`keel`.`environment`.`uid` = `keel`.`environment_version`.`environment_uid`) and (`keel`.`environment_version`.`version` = (select max(`ev2`.`version`) from `keel`.`environment_version` `ev2` where (`keel`.`environment`.`uid` = `ev2`.`environment_uid`))))))"));
    }

    public <O extends Record> LatestEnvironment(Table<O> child, ForeignKey<O, LatestEnvironmentRecord> key) {
        super(child, key, (Table)LATEST_ENVIRONMENT);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public LatestEnvironment as(String alias) {
        return new LatestEnvironment(DSL.name((String)alias), (Table<LatestEnvironmentRecord>)this);
    }

    public LatestEnvironment as(Name alias) {
        return new LatestEnvironment(alias, (Table<LatestEnvironmentRecord>)this);
    }

    public LatestEnvironment rename(String name) {
        return new LatestEnvironment(DSL.name((String)name), null);
    }

    public LatestEnvironment rename(Name name) {
        return new LatestEnvironment(name, null);
    }

    public Row9<String, String, String, Integer, Boolean, String, String, String, String> fieldsRow() {
        return (Row9)super.fieldsRow();
    }
}

