/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.jooq.LocalDateTimeToInstantConverter;
import com.netflix.spinnaker.keel.core.api.PromotionStatus;
import com.netflix.spinnaker.keel.persistence.metamodel.Indexes;
import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.Keys;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.DeliveryArtifact;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.Environment;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.EnvironmentArtifactVersionsRecord;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row9;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.EnumConverter;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class EnvironmentArtifactVersions
extends TableImpl<EnvironmentArtifactVersionsRecord> {
    private static final long serialVersionUID = 529088328L;
    public static final EnvironmentArtifactVersions ENVIRONMENT_ARTIFACT_VERSIONS = new EnvironmentArtifactVersions();
    public final TableField<EnvironmentArtifactVersionsRecord, String> ENVIRONMENT_UID = EnvironmentArtifactVersions.createField((Name)DSL.name((String)"environment_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactVersionsRecord, String> ARTIFACT_UID = EnvironmentArtifactVersions.createField((Name)DSL.name((String)"artifact_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactVersionsRecord, String> ARTIFACT_VERSION = EnvironmentArtifactVersions.createField((Name)DSL.name((String)"artifact_version"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactVersionsRecord, Instant> APPROVED_AT = EnvironmentArtifactVersions.createField((Name)DSL.name((String)"approved_at"), (DataType)SQLDataType.LOCALDATETIME, (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());
    public final TableField<EnvironmentArtifactVersionsRecord, Instant> DEPLOYED_AT = EnvironmentArtifactVersions.createField((Name)DSL.name((String)"deployed_at"), (DataType)SQLDataType.LOCALDATETIME, (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());
    public final TableField<EnvironmentArtifactVersionsRecord, PromotionStatus> PROMOTION_STATUS = EnvironmentArtifactVersions.createField((Name)DSL.name((String)"promotion_status"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"", (Converter)new EnumConverter(String.class, PromotionStatus.class));
    public final TableField<EnvironmentArtifactVersionsRecord, String> PROMOTION_REFERENCE = EnvironmentArtifactVersions.createField((Name)DSL.name((String)"promotion_reference"), (DataType)SQLDataType.VARCHAR((int)255), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactVersionsRecord, String> REPLACED_BY = EnvironmentArtifactVersions.createField((Name)DSL.name((String)"replaced_by"), (DataType)SQLDataType.VARCHAR((int)255), (Table)this, (String)"");
    public final TableField<EnvironmentArtifactVersionsRecord, Instant> REPLACED_AT = EnvironmentArtifactVersions.createField((Name)DSL.name((String)"replaced_at"), (DataType)SQLDataType.LOCALDATETIME, (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());

    public Class<EnvironmentArtifactVersionsRecord> getRecordType() {
        return EnvironmentArtifactVersionsRecord.class;
    }

    public EnvironmentArtifactVersions() {
        this(DSL.name((String)"environment_artifact_versions"), null);
    }

    public EnvironmentArtifactVersions(String alias) {
        this(DSL.name((String)alias), (Table<EnvironmentArtifactVersionsRecord>)ENVIRONMENT_ARTIFACT_VERSIONS);
    }

    public EnvironmentArtifactVersions(Name alias) {
        this(alias, (Table<EnvironmentArtifactVersionsRecord>)ENVIRONMENT_ARTIFACT_VERSIONS);
    }

    private EnvironmentArtifactVersions(Name alias, Table<EnvironmentArtifactVersionsRecord> aliased) {
        this(alias, aliased, null);
    }

    private EnvironmentArtifactVersions(Name alias, Table<EnvironmentArtifactVersionsRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public <O extends Record> EnvironmentArtifactVersions(Table<O> child, ForeignKey<O, EnvironmentArtifactVersionsRecord> key) {
        super(child, key, (Table)ENVIRONMENT_ARTIFACT_VERSIONS);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.ENVIRONMENT_ARTIFACT_VERSIONS_EAV_STATUS_IDX, Indexes.ENVIRONMENT_ARTIFACT_VERSIONS_ENVIRONMENT_ARTIFACT_VERSIONS_APPROVED_AT_IDX, Indexes.ENVIRONMENT_ARTIFACT_VERSIONS_ENVIRONMENT_ARTIFACT_VERSIONS_DEPLOYED_AT_IDX);
    }

    public UniqueKey<EnvironmentArtifactVersionsRecord> getPrimaryKey() {
        return Keys.KEY_ENVIRONMENT_ARTIFACT_VERSIONS_PRIMARY;
    }

    public List<UniqueKey<EnvironmentArtifactVersionsRecord>> getKeys() {
        return Arrays.asList(Keys.KEY_ENVIRONMENT_ARTIFACT_VERSIONS_PRIMARY);
    }

    public List<ForeignKey<EnvironmentArtifactVersionsRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_ENVIRONMENT_ARTIFACT_VERSIONS_ENVIRONMENT, Keys.FK_ENVIRONMENT_ARTIFACT_VERSIONS_DELIVERY_ARTIFACT);
    }

    public Environment environment() {
        return new Environment(this, Keys.FK_ENVIRONMENT_ARTIFACT_VERSIONS_ENVIRONMENT);
    }

    public DeliveryArtifact deliveryArtifact() {
        return new DeliveryArtifact(this, Keys.FK_ENVIRONMENT_ARTIFACT_VERSIONS_DELIVERY_ARTIFACT);
    }

    public EnvironmentArtifactVersions as(String alias) {
        return new EnvironmentArtifactVersions(DSL.name((String)alias), (Table<EnvironmentArtifactVersionsRecord>)this);
    }

    public EnvironmentArtifactVersions as(Name alias) {
        return new EnvironmentArtifactVersions(alias, (Table<EnvironmentArtifactVersionsRecord>)this);
    }

    public EnvironmentArtifactVersions rename(String name) {
        return new EnvironmentArtifactVersions(DSL.name((String)name), null);
    }

    public EnvironmentArtifactVersions rename(Name name) {
        return new EnvironmentArtifactVersions(name, null);
    }

    public Row9<String, String, String, Instant, Instant, PromotionStatus, String, String, Instant> fieldsRow() {
        return (Row9)super.fieldsRow();
    }
}

