/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.jooq.LocalDateTimeToInstantConverter;
import com.netflix.spinnaker.keel.persistence.metamodel.Indexes;
import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.Keys;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.DeliveryArtifact;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.ArtifactLastCheckedRecord;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row2;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class ArtifactLastChecked
extends TableImpl<ArtifactLastCheckedRecord> {
    private static final long serialVersionUID = -1261475995L;
    public static final ArtifactLastChecked ARTIFACT_LAST_CHECKED = new ArtifactLastChecked();
    public final TableField<ArtifactLastCheckedRecord, String> ARTIFACT_UID = ArtifactLastChecked.createField((Name)DSL.name((String)"artifact_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<ArtifactLastCheckedRecord, Instant> AT = ArtifactLastChecked.createField((Name)DSL.name((String)"at"), (DataType)SQLDataType.LOCALDATETIME.nullable(false).defaultValue(DSL.field((String)"CURRENT_TIMESTAMP(3)", (DataType)SQLDataType.LOCALDATETIME)), (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());

    public Class<ArtifactLastCheckedRecord> getRecordType() {
        return ArtifactLastCheckedRecord.class;
    }

    public ArtifactLastChecked() {
        this(DSL.name((String)"artifact_last_checked"), null);
    }

    public ArtifactLastChecked(String alias) {
        this(DSL.name((String)alias), (Table<ArtifactLastCheckedRecord>)ARTIFACT_LAST_CHECKED);
    }

    public ArtifactLastChecked(Name alias) {
        this(alias, (Table<ArtifactLastCheckedRecord>)ARTIFACT_LAST_CHECKED);
    }

    private ArtifactLastChecked(Name alias, Table<ArtifactLastCheckedRecord> aliased) {
        this(alias, aliased, null);
    }

    private ArtifactLastChecked(Name alias, Table<ArtifactLastCheckedRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public <O extends Record> ArtifactLastChecked(Table<O> child, ForeignKey<O, ArtifactLastCheckedRecord> key) {
        super(child, key, (Table)ARTIFACT_LAST_CHECKED);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.ARTIFACT_LAST_CHECKED_ARTIFACT_LAST_CHECKED_AT_IDX);
    }

    public UniqueKey<ArtifactLastCheckedRecord> getPrimaryKey() {
        return Keys.KEY_ARTIFACT_LAST_CHECKED_PRIMARY;
    }

    public List<UniqueKey<ArtifactLastCheckedRecord>> getKeys() {
        return Arrays.asList(Keys.KEY_ARTIFACT_LAST_CHECKED_PRIMARY);
    }

    public List<ForeignKey<ArtifactLastCheckedRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_ARTIFACT_LAST_CHECKED_DELIVERY_ARTIFACT);
    }

    public DeliveryArtifact deliveryArtifact() {
        return new DeliveryArtifact(this, Keys.FK_ARTIFACT_LAST_CHECKED_DELIVERY_ARTIFACT);
    }

    public ArtifactLastChecked as(String alias) {
        return new ArtifactLastChecked(DSL.name((String)alias), (Table<ArtifactLastCheckedRecord>)this);
    }

    public ArtifactLastChecked as(Name alias) {
        return new ArtifactLastChecked(alias, (Table<ArtifactLastCheckedRecord>)this);
    }

    public ArtifactLastChecked rename(String name) {
        return new ArtifactLastChecked(DSL.name((String)name), null);
    }

    public ArtifactLastChecked rename(Name name) {
        return new ArtifactLastChecked(name, null);
    }

    public Row2<String, Instant> fieldsRow() {
        return (Row2)super.fieldsRow();
    }
}

