/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.EnvironmentExclusionConfig;
import com.netflix.spinnaker.keel.api.plugins.ArtifactSupplier;
import com.netflix.spinnaker.keel.events.PersistentEvent;
import com.netflix.spinnaker.keel.resources.ResourceSpecIdentifier;
import com.netflix.spinnaker.keel.resources.SpecMigrator;
import com.netflix.spinnaker.keel.scheduled.ScheduledAgent;
import com.netflix.spinnaker.keel.sql.SqlActionRepository;
import com.netflix.spinnaker.keel.sql.SqlAgentLockRepository;
import com.netflix.spinnaker.keel.sql.SqlArtifactRepository;
import com.netflix.spinnaker.keel.sql.SqlBakedImageRepository;
import com.netflix.spinnaker.keel.sql.SqlDeliveryConfigRepository;
import com.netflix.spinnaker.keel.sql.SqlDiffFingerprintRepository;
import com.netflix.spinnaker.keel.sql.SqlEnvironmentLeaseRepository;
import com.netflix.spinnaker.keel.sql.SqlLifecycleEventRepository;
import com.netflix.spinnaker.keel.sql.SqlLifecycleMonitorRepository;
import com.netflix.spinnaker.keel.sql.SqlNotificationRepository;
import com.netflix.spinnaker.keel.sql.SqlPausedRepository;
import com.netflix.spinnaker.keel.sql.SqlResourceRepository;
import com.netflix.spinnaker.keel.sql.SqlRetry;
import com.netflix.spinnaker.keel.sql.SqlTaskTrackingRepository;
import com.netflix.spinnaker.keel.sql.SqlUnhappyVetoRepository;
import com.netflix.spinnaker.keel.sql.SqlUnhealthyRepository;
import com.netflix.spinnaker.kork.sql.config.DefaultSqlConfiguration;
import com.netflix.spinnaker.kork.sql.config.SqlProperties;
import com.netflix.spinnaker.kork.sql.config.SqlRetryProperties;
import java.time.Clock;
import java.util.List;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.conf.Settings;
import org.jooq.impl.DefaultConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(value={"sql.enabled"})
@Import(value={DefaultSqlConfiguration.class, SqlRetryProperties.class, EnvironmentExclusionConfig.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0017J>\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0014\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030%0\u001e2\u0006\u0010&\u001a\u00020'H\u0017J(\u0010(\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0017J\\\u0010*\u001a\u00020+2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u0010\"\u001a\u00020#2\u0014\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030%0\u001e2\u0014\u0010.\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/0\u001e2\u0006\u0010&\u001a\u00020'H\u0017J\u0018\u00100\u001a\u0002012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J \u00102\u001a\u0002032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00104\u001a\u000205H\u0017J8\u00106\u001a\u0002072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u00108\u001a\u0002052\u0006\u0010&\u001a\u00020'H\u0017J(\u00109\u001a\u00020:2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0017J \u0010;\u001a\u00020<2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0010\u0010=\u001a\u00020>2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017JF\u0010?\u001a\u00020@2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0014\u0010.\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/0\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0017J\u0018\u0010A\u001a\u00020B2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\b\u0010C\u001a\u00020DH\u0017J\u0010\u0010E\u001a\u00020F2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J \u0010G\u001a\u00020H2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\\\u0010I\u001a\u00020J2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u0010\"\u001a\u00020#2\u0014\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030%0\u001e2\u0014\u0010.\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/0\u001e2\u0006\u0010K\u001a\u00020LH\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006M"}, d2={"Lcom/netflix/spinnaker/config/SqlConfiguration;", "", "()V", "environmentExclusionConfig", "Lcom/netflix/spinnaker/config/EnvironmentExclusionConfig;", "getEnvironmentExclusionConfig", "()Lcom/netflix/spinnaker/config/EnvironmentExclusionConfig;", "setEnvironmentExclusionConfig", "(Lcom/netflix/spinnaker/config/EnvironmentExclusionConfig;)V", "jooqConfiguration", "Lorg/jooq/impl/DefaultConfiguration;", "getJooqConfiguration", "()Lorg/jooq/impl/DefaultConfiguration;", "setJooqConfiguration", "(Lorg/jooq/impl/DefaultConfiguration;)V", "sqlRetryProperties", "Lcom/netflix/spinnaker/kork/sql/config/SqlRetryProperties;", "getSqlRetryProperties", "()Lcom/netflix/spinnaker/kork/sql/config/SqlRetryProperties;", "setSqlRetryProperties", "(Lcom/netflix/spinnaker/kork/sql/config/SqlRetryProperties;)V", "agentLockRepository", "Lcom/netflix/spinnaker/keel/sql/SqlAgentLockRepository;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "properties", "Lcom/netflix/spinnaker/kork/sql/config/SqlProperties;", "agents", "", "Lcom/netflix/spinnaker/keel/scheduled/ScheduledAgent;", "artifactRepository", "Lcom/netflix/spinnaker/keel/sql/SqlArtifactRepository;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "artifactSuppliers", "Lcom/netflix/spinnaker/keel/api/plugins/ArtifactSupplier;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "bakedImageRepository", "Lcom/netflix/spinnaker/keel/sql/SqlBakedImageRepository;", "deliveryConfigRepository", "Lcom/netflix/spinnaker/keel/sql/SqlDeliveryConfigRepository;", "resourceSpecIdentifier", "Lcom/netflix/spinnaker/keel/resources/ResourceSpecIdentifier;", "specMigrators", "Lcom/netflix/spinnaker/keel/resources/SpecMigrator;", "diffFingerprintRepository", "Lcom/netflix/spinnaker/keel/sql/SqlDiffFingerprintRepository;", "environmentLeaseRepository", "Lcom/netflix/spinnaker/keel/sql/SqlEnvironmentLeaseRepository;", "registry", "Lcom/netflix/spectator/api/Registry;", "lifecycleEventRepository", "Lcom/netflix/spinnaker/keel/sql/SqlLifecycleEventRepository;", "spectator", "lifecycleMonitorRepository", "Lcom/netflix/spinnaker/keel/sql/SqlLifecycleMonitorRepository;", "notificationRepository", "Lcom/netflix/spinnaker/keel/sql/SqlNotificationRepository;", "pausedRepository", "Lcom/netflix/spinnaker/keel/sql/SqlPausedRepository;", "resourceRepository", "Lcom/netflix/spinnaker/keel/sql/SqlResourceRepository;", "taskTrackingRepository", "Lcom/netflix/spinnaker/keel/sql/SqlTaskTrackingRepository;", "tweakJooqConfiguration", "", "unhappyVetoRepository", "Lcom/netflix/spinnaker/keel/sql/SqlUnhappyVetoRepository;", "unhealthyRepository", "Lcom/netflix/spinnaker/keel/sql/SqlUnhealthyRepository;", "verificationRepository", "Lcom/netflix/spinnaker/keel/sql/SqlActionRepository;", "environment", "Lorg/springframework/core/env/Environment;", "keel-sql"})
public class SqlConfiguration {
    @Autowired
    public DefaultConfiguration jooqConfiguration;
    @Autowired
    public SqlRetryProperties sqlRetryProperties;
    @Autowired
    public EnvironmentExclusionConfig environmentExclusionConfig;

    @NotNull
    public DefaultConfiguration getJooqConfiguration() {
        DefaultConfiguration defaultConfiguration = this.jooqConfiguration;
        if (defaultConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"jooqConfiguration");
        }
        return defaultConfiguration;
    }

    public void setJooqConfiguration(@NotNull DefaultConfiguration defaultConfiguration) {
        Intrinsics.checkNotNullParameter((Object)defaultConfiguration, (String)"<set-?>");
        this.jooqConfiguration = defaultConfiguration;
    }

    @NotNull
    public SqlRetryProperties getSqlRetryProperties() {
        SqlRetryProperties sqlRetryProperties = this.sqlRetryProperties;
        if (sqlRetryProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sqlRetryProperties");
        }
        return sqlRetryProperties;
    }

    public void setSqlRetryProperties(@NotNull SqlRetryProperties sqlRetryProperties) {
        Intrinsics.checkNotNullParameter((Object)sqlRetryProperties, (String)"<set-?>");
        this.sqlRetryProperties = sqlRetryProperties;
    }

    @NotNull
    public EnvironmentExclusionConfig getEnvironmentExclusionConfig() {
        EnvironmentExclusionConfig environmentExclusionConfig = this.environmentExclusionConfig;
        if (environmentExclusionConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environmentExclusionConfig");
        }
        return environmentExclusionConfig;
    }

    public void setEnvironmentExclusionConfig(@NotNull EnvironmentExclusionConfig environmentExclusionConfig) {
        Intrinsics.checkNotNullParameter((Object)environmentExclusionConfig, (String)"<set-?>");
        this.environmentExclusionConfig = environmentExclusionConfig;
    }

    @PostConstruct
    public void tweakJooqConfiguration() {
        Settings settings = this.getJooqConfiguration().settings();
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"jooqConfiguration.settings()");
        settings.setRenderSchema(Boolean.valueOf(false));
    }

    @Bean
    @NotNull
    public SqlResourceRepository resourceRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ResourceSpecIdentifier resourceSpecIdentifier, @NotNull List<? extends SpecMigrator<?, ?>> specMigrators, @NotNull ObjectMapper objectMapper, @NotNull ApplicationEventPublisher publisher) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)resourceSpecIdentifier, (String)"resourceSpecIdentifier");
        Intrinsics.checkNotNullParameter(specMigrators, (String)"specMigrators");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        return new SqlResourceRepository(jooq, clock, resourceSpecIdentifier, specMigrators, objectMapper, new SqlRetry(this.getSqlRetryProperties()), publisher);
    }

    @Bean
    @NotNull
    public SqlArtifactRepository artifactRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ObjectMapper objectMapper, @NotNull List<? extends ArtifactSupplier<?, ?>> artifactSuppliers, @NotNull ApplicationEventPublisher publisher) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter(artifactSuppliers, (String)"artifactSuppliers");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        return new SqlArtifactRepository(jooq, clock, objectMapper, new SqlRetry(this.getSqlRetryProperties()), artifactSuppliers, publisher);
    }

    @Bean
    @NotNull
    public SqlDeliveryConfigRepository deliveryConfigRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ResourceSpecIdentifier resourceSpecIdentifier, @NotNull ObjectMapper objectMapper, @NotNull List<? extends ArtifactSupplier<?, ?>> artifactSuppliers, @NotNull List<? extends SpecMigrator<?, ?>> specMigrators, @NotNull ApplicationEventPublisher publisher) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)resourceSpecIdentifier, (String)"resourceSpecIdentifier");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter(artifactSuppliers, (String)"artifactSuppliers");
        Intrinsics.checkNotNullParameter(specMigrators, (String)"specMigrators");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        return new SqlDeliveryConfigRepository(jooq, clock, resourceSpecIdentifier, objectMapper, new SqlRetry(this.getSqlRetryProperties()), artifactSuppliers, specMigrators, publisher);
    }

    @Bean
    @NotNull
    public SqlDiffFingerprintRepository diffFingerprintRepository(@NotNull DSLContext jooq, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new SqlDiffFingerprintRepository(jooq, clock, new SqlRetry(this.getSqlRetryProperties()));
    }

    @Bean
    @NotNull
    public SqlUnhappyVetoRepository unhappyVetoRepository(@NotNull DSLContext jooq) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        return new SqlUnhappyVetoRepository(PersistentEvent.Companion.getClock(), jooq, new SqlRetry(this.getSqlRetryProperties()));
    }

    @Bean
    @NotNull
    public SqlPausedRepository pausedRepository(@NotNull DSLContext jooq) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        return new SqlPausedRepository(jooq, new SqlRetry(this.getSqlRetryProperties()), PersistentEvent.Companion.getClock());
    }

    @Bean
    @NotNull
    public SqlTaskTrackingRepository taskTrackingRepository(@NotNull DSLContext jooq, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new SqlTaskTrackingRepository(jooq, clock, new SqlRetry(this.getSqlRetryProperties()));
    }

    @Bean
    @NotNull
    public SqlAgentLockRepository agentLockRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull SqlProperties properties, @NotNull List<? extends ScheduledAgent> agents) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(agents, (String)"agents");
        return new SqlAgentLockRepository(jooq, clock, agents, new SqlRetry(this.getSqlRetryProperties()));
    }

    @Bean
    @NotNull
    public SqlNotificationRepository notificationRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull SqlProperties properties) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new SqlNotificationRepository(clock, jooq, new SqlRetry(this.getSqlRetryProperties()));
    }

    @Bean
    @NotNull
    public SqlUnhealthyRepository unhealthyRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull SqlProperties properties) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new SqlUnhealthyRepository(clock, jooq, new SqlRetry(this.getSqlRetryProperties()));
    }

    @Bean
    @NotNull
    public SqlActionRepository verificationRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ResourceSpecIdentifier resourceSpecIdentifier, @NotNull ObjectMapper objectMapper, @NotNull List<? extends ArtifactSupplier<?, ?>> artifactSuppliers, @NotNull List<? extends SpecMigrator<?, ?>> specMigrators, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)resourceSpecIdentifier, (String)"resourceSpecIdentifier");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter(artifactSuppliers, (String)"artifactSuppliers");
        Intrinsics.checkNotNullParameter(specMigrators, (String)"specMigrators");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return new SqlActionRepository(jooq, clock, resourceSpecIdentifier, objectMapper, new SqlRetry(this.getSqlRetryProperties()), artifactSuppliers, specMigrators, environment);
    }

    @Bean
    @NotNull
    public SqlLifecycleEventRepository lifecycleEventRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull SqlProperties properties, @NotNull ObjectMapper objectMapper, @NotNull Registry spectator, @NotNull ApplicationEventPublisher publisher) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)spectator, (String)"spectator");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        return new SqlLifecycleEventRepository(clock, jooq, new SqlRetry(this.getSqlRetryProperties()), spectator, publisher);
    }

    @Bean
    @NotNull
    public SqlLifecycleMonitorRepository lifecycleMonitorRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull SqlProperties properties, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new SqlLifecycleMonitorRepository(jooq, clock, objectMapper, new SqlRetry(this.getSqlRetryProperties()));
    }

    @Bean
    @NotNull
    public SqlBakedImageRepository bakedImageRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull SqlProperties properties, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new SqlBakedImageRepository(jooq, clock, objectMapper, new SqlRetry(this.getSqlRetryProperties()));
    }

    @Bean
    @NotNull
    public SqlEnvironmentLeaseRepository environmentLeaseRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return new SqlEnvironmentLeaseRepository(jooq, clock, registry, this.getEnvironmentExclusionConfig().getLeaseDuration());
    }
}

