/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.PutFunctionConcurrencyRequest;
import com.amazonaws.services.lambda.model.PutFunctionConcurrencyResult;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.PutLambdaReservedConcurrencyDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class PutLambdaReservedConcurrencyAtomicOperation
extends AbstractLambdaAtomicOperation<PutLambdaReservedConcurrencyDescription, PutFunctionConcurrencyResult>
implements AtomicOperation<PutFunctionConcurrencyResult> {
    public PutLambdaReservedConcurrencyAtomicOperation(PutLambdaReservedConcurrencyDescription description) {
        super(description, "PUT_LAMBDA_FUNCTION_RESERVED_CONCURRENCY");
    }

    public PutFunctionConcurrencyResult operate(List priorOutputs) {
        this.updateTaskStatus("Initializing Atomic Operation AWS Lambda for PutReservedConcurrency...");
        return this.putReservedFunctionConcurrency(((PutLambdaReservedConcurrencyDescription)this.description).getFunctionName(), ((PutLambdaReservedConcurrencyDescription)this.description).getReservedConcurrentExecutions());
    }

    private PutFunctionConcurrencyResult putReservedFunctionConcurrency(String functionName, int reservedConcurrentExecutions) {
        AWSLambda client = this.getLambdaClient();
        PutFunctionConcurrencyRequest req = new PutFunctionConcurrencyRequest().withFunctionName(functionName).withReservedConcurrentExecutions(Integer.valueOf(reservedConcurrentExecutions));
        PutFunctionConcurrencyResult result = client.putFunctionConcurrency(req);
        this.updateTaskStatus("Finished Atomic Operation AWS Lambda for PutReservedConcurrency...");
        return result;
    }
}

