/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.DeleteFunctionConcurrencyRequest;
import com.amazonaws.services.lambda.model.DeleteFunctionConcurrencyResult;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.DeleteLambdaReservedConcurrencyDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class DeleteLambdaReservedConcurrencyAtomicOperation
extends AbstractLambdaAtomicOperation<DeleteLambdaReservedConcurrencyDescription, DeleteFunctionConcurrencyResult>
implements AtomicOperation<DeleteFunctionConcurrencyResult> {
    public DeleteLambdaReservedConcurrencyAtomicOperation(DeleteLambdaReservedConcurrencyDescription description) {
        super(description, "DELETE_LAMBDA_FUNCTION_RESERVED_CONCURRENCY");
    }

    public DeleteFunctionConcurrencyResult operate(List priorOutputs) {
        this.updateTaskStatus("Initializing Atomic Operation AWS Lambda for DeleteReservedConcurrency...");
        return this.deleteReservedFunctionConcurrency(((DeleteLambdaReservedConcurrencyDescription)this.description).getFunctionName());
    }

    private DeleteFunctionConcurrencyResult deleteReservedFunctionConcurrency(String functionName) {
        AWSLambda client = this.getLambdaClient();
        DeleteFunctionConcurrencyRequest req = new DeleteFunctionConcurrencyRequest().withFunctionName(functionName);
        DeleteFunctionConcurrencyResult result = client.deleteFunctionConcurrency(req);
        this.updateTaskStatus("Finished Atomic Operation AWS Lambda for DeleteReservedConcurrency...");
        return result;
    }
}

