/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.cache.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.awsobjectmapper.AmazonObjectMapperConfigurer;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.lambda.cache.Keys;
import com.netflix.spinnaker.clouddriver.lambda.cache.client.AbstractCacheClient;
import com.netflix.spinnaker.clouddriver.lambda.cache.model.LambdaFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LambdaCacheClient
extends AbstractCacheClient<LambdaFunction> {
    private final ObjectMapper objectMapper = AmazonObjectMapperConfigurer.createConfigured();

    @Autowired
    public LambdaCacheClient(Cache cacheView) {
        super(cacheView, Keys.Namespace.LAMBDA_FUNCTIONS.ns);
    }

    @Override
    protected LambdaFunction convert(CacheData cacheData) {
        Map attributes = cacheData.getAttributes();
        LambdaFunction lambdaFunction = (LambdaFunction)((Object)this.objectMapper.convertValue((Object)attributes, LambdaFunction.class));
        List eventSourceMappings = (List)attributes.get("eventSourceMappings");
        if (eventSourceMappings == null) {
            return lambdaFunction;
        }
        HashMap arnUuidMap = new HashMap();
        eventSourceMappings.stream().forEach(xx -> arnUuidMap.put((String)xx.get("eventSourceArn"), (String)xx.get("uuid")));
        lambdaFunction.getEventSourceMappings().forEach(currMapping -> currMapping.setUUID((String)arnUuidMap.get(currMapping.getEventSourceArn())));
        return lambdaFunction;
    }
}

