/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.config;

import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.config.HoverflyConfigValidator;
import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;
import io.specto.hoverfly.junit.core.config.LocalMiddleware;
import io.specto.hoverfly.junit.core.config.LogLevel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHoverflyConfig
extends HoverflyConfig {
    private String caCertPath;
    private String caKeyPath;
    private boolean tlsVerificationDisabled;
    private boolean plainHttpTunneling;
    private LocalMiddleware localMiddleware;
    private String upstreamProxy;
    private Logger hoverflyLogger = LoggerFactory.getLogger((String)"hoverfly");
    private LogLevel logLevel;
    private List<String> commands = new LinkedList<String>();
    private String binaryLocation;
    private String clientCertPath;
    private String clientKeyPath;
    private String clientAuthDestination;
    private String clientCaCertPath;

    @Deprecated
    public LocalHoverflyConfig sslCertificatePath(String sslCertificatePath) {
        this.caCertPath = sslCertificatePath;
        return this;
    }

    @Deprecated
    public LocalHoverflyConfig sslKeyPath(String sslKeyPath) {
        this.caKeyPath = sslKeyPath;
        return this;
    }

    public LocalHoverflyConfig overrideDefaultCaCert(String certPath, String keyPath) {
        this.caCertPath = certPath;
        this.caKeyPath = keyPath;
        return this;
    }

    public LocalHoverflyConfig localMiddleware(String binary, String path) {
        this.localMiddleware = new LocalMiddleware(binary, path);
        return this;
    }

    public LocalHoverflyConfig disableTlsVerification() {
        this.tlsVerificationDisabled = true;
        return this;
    }

    public LocalHoverflyConfig plainHttpTunneling() {
        this.plainHttpTunneling = true;
        return this;
    }

    public LocalHoverflyConfig upstreamProxy(InetSocketAddress proxyAddress) {
        this.upstreamProxy = proxyAddress.getHostString() + ":" + proxyAddress.getPort();
        return this;
    }

    public LocalHoverflyConfig upstreamProxy(String upstreamProxy) {
        this.upstreamProxy = upstreamProxy;
        return this;
    }

    public LocalHoverflyConfig logger(String loggerName) {
        this.hoverflyLogger = LoggerFactory.getLogger((String)loggerName);
        return this;
    }

    public LocalHoverflyConfig logToStdOut() {
        this.hoverflyLogger = null;
        return this;
    }

    public LocalHoverflyConfig logLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public LocalHoverflyConfig addCommands(String ... commands) {
        this.commands.addAll(Arrays.asList(commands));
        return this;
    }

    public HoverflyConfig binaryLocation(String binaryLocation) {
        this.binaryLocation = binaryLocation;
        return this;
    }

    public LocalHoverflyConfig enableClientAuth(String clientCertPath, String clientKeyPath, String ... destinations) {
        this.clientCertPath = clientCertPath;
        this.clientKeyPath = clientKeyPath;
        if (destinations != null) {
            this.clientAuthDestination = destinations.length == 0 ? "." : String.join((CharSequence)"|", destinations);
        }
        return this;
    }

    public LocalHoverflyConfig clientAuthCaCertPath(String clientCaCertPath) {
        this.clientCaCertPath = clientCaCertPath;
        return this;
    }

    @Override
    public HoverflyConfiguration build() {
        HoverflyConfiguration configs = new HoverflyConfiguration(this.proxyPort, this.adminPort, this.proxyLocalHost, this.destination, this.proxyCaCert, this.captureHeaders, this.webServer, this.hoverflyLogger, this.logLevel, this.statefulCapture, this.incrementalCapture, this.simulationPreprocessor);
        configs.setSslCertificatePath(this.caCertPath);
        configs.setSslKeyPath(this.caKeyPath);
        configs.setTlsVerificationDisabled(this.tlsVerificationDisabled);
        configs.setPlainHttpTunneling(this.plainHttpTunneling);
        configs.setLocalMiddleware(this.localMiddleware);
        configs.setUpstreamProxy(this.upstreamProxy);
        configs.setCommands(this.commands);
        configs.setBinaryLocation(this.binaryLocation);
        configs.setClientCertPath(this.clientCertPath);
        configs.setClientKeyPath(this.clientKeyPath);
        configs.setClientAuthDestination(this.clientAuthDestination);
        configs.setClientCaCertPath(this.clientCaCertPath);
        configs.setResponseBodyFilesPath(this.responseBodyFilesPath);
        configs.setRelativeResponseBodyFilesPath(this.isRelativeResponseBodyFilesPath);
        HoverflyConfigValidator validator = new HoverflyConfigValidator();
        return validator.validate(configs);
    }
}

