/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.verification;

import io.specto.hoverfly.junit.core.model.JournalEntry;
import io.specto.hoverfly.junit.core.model.RequestDetails;
import java.time.format.DateTimeFormatter;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class VerificationUtils {
    private VerificationUtils() {
    }

    static String format(JournalEntry entry) {
        RequestDetails request = entry.getRequest();
        String url = VerificationUtils.formatUrl(request);
        String headers = VerificationUtils.formatHeaders(request);
        String body = VerificationUtils.formatBody(request);
        String time = entry.getTimeStarted().toLocalDateTime().format(DateTimeFormatter.ISO_DATE_TIME);
        String requestLog = StringUtils.isBlank((CharSequence)body) ? String.format("[%s] %s %s HTTP/1.1\n%s\n", time, request.getMethod().toUpperCase(), url, headers) : String.format("[%s] %s %s HTTP/1.1\n%s\n%s\n", time, request.getMethod().toUpperCase(), url, headers, body);
        return requestLog;
    }

    private static String formatBody(RequestDetails request) {
        return request.getBody();
    }

    private static String formatHeaders(RequestDetails request) {
        return request.getHeaders().entrySet().stream().map(entry -> (String)entry.getKey() + ": [" + String.join((CharSequence)", ", (Iterable)entry.getValue()) + "]").collect(Collectors.joining("\n"));
    }

    private static String formatUrl(RequestDetails request) {
        String query = StringUtils.isBlank((CharSequence)request.getQuery()) ? "" : "?" + request.getQuery();
        return request.getScheme() + "://" + request.getDestination() + request.getPath() + query;
    }
}

