/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.HoverflyUtils;
import io.specto.hoverfly.junit.core.SystemConfig;
import io.specto.hoverfly.junit.core.SystemConfigFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TempFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempFileManager.class);
    private static final String TEMP_DIR_PREFIX = "hoverfly.";
    private static final String HOVERFLY_BINARIES_ROOT_PATH = "binaries/";
    private Path tempDirectory;

    TempFileManager() {
    }

    void purge() {
        if (this.tempDirectory == null) {
            return;
        }
        try {
            Files.walk(this.tempDirectory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            this.tempDirectory = null;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete hoverfly binary, will try again on JVM shutdown.", (Throwable)e);
        }
    }

    Path copyClassPathResource(String resourcePath, String targetName) {
        Path targetPath = this.getOrCreateTempDirectory().resolve(targetName);
        try (InputStream resourceAsStream = HoverflyUtils.getClasspathResourceAsStream(resourcePath);){
            Files.copy(resourceAsStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to copy classpath resource " + resourcePath, e);
        }
        return targetPath;
    }

    Path copyHoverflyBinary(SystemConfig systemConfig) {
        String binaryName = systemConfig.getHoverflyBinaryName();
        LOGGER.info("Selecting the following binary based on the current operating system: {}", (Object)binaryName);
        Path targetPath = this.getOrCreateTempDirectory().resolve(binaryName);
        LOGGER.info("Storing binary in temporary directory {}", (Object)targetPath);
        try (InputStream resourceAsStream = HoverflyUtils.getClasspathResourceAsStream(HOVERFLY_BINARIES_ROOT_PATH + binaryName);){
            Files.copy(resourceAsStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
            if (systemConfig.getOsName() == SystemConfigFactory.OsName.WINDOWS) {
                File targetFile = targetPath.toFile();
                targetFile.setExecutable(true);
                targetFile.setReadable(true);
                targetFile.setWritable(true);
            } else {
                Files.setPosixFilePermissions(targetPath, new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ)));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to copy hoverfly binary.", e);
        }
        return targetPath;
    }

    Path getTempDirectory() {
        return this.tempDirectory;
    }

    private Path getOrCreateTempDirectory() {
        if (this.tempDirectory == null) {
            try {
                this.tempDirectory = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create temp directory.", e);
            }
        }
        return this.tempDirectory;
    }

    void setBinaryLocation(String binaryLocation) {
        this.tempDirectory = Paths.get(binaryLocation, new String[0]).toAbsolutePath();
    }
}

