/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.RequestFieldMatcher;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AbstractDelaySettingsBuilder {
    private final int delay;
    private final TimeUnit delayTimeUnit;

    public AbstractDelaySettingsBuilder(int delay, TimeUnit delayTimeUnit) {
        this.delay = delay;
        this.delayTimeUnit = delayTimeUnit;
    }

    protected String toPattern(List<RequestFieldMatcher> matchers) {
        return matchers.stream().filter(m -> m.getMatcher() == RequestFieldMatcher.MatcherType.EXACT || m.getMatcher() == RequestFieldMatcher.MatcherType.REGEX).findFirst().map(RequestFieldMatcher::getValue).map(Object::toString).orElseThrow(() -> new IllegalStateException("None of the exact/regex matcher is set. "));
    }

    protected int getConvertedDelay() {
        assert (this.isValid());
        return (int)this.delayTimeUnit.toMillis(this.delay);
    }

    protected boolean isValid() {
        return this.delayTimeUnit != null && this.delay > 0;
    }
}

