/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.api;

import com.fasterxml.jackson.databind.JsonNode;
import io.specto.hoverfly.junit.api.OkHttpHoverflyClient;
import io.specto.hoverfly.junit.api.command.SortParams;
import io.specto.hoverfly.junit.api.model.ModeArguments;
import io.specto.hoverfly.junit.api.view.DiffView;
import io.specto.hoverfly.junit.api.view.HoverflyInfoView;
import io.specto.hoverfly.junit.api.view.StateView;
import io.specto.hoverfly.junit.core.HoverflyMode;
import io.specto.hoverfly.junit.core.model.Journal;
import io.specto.hoverfly.junit.core.model.Request;
import io.specto.hoverfly.junit.core.model.Simulation;
import okhttp3.OkHttpClient;

public interface HoverflyClient {
    public void setSimulation(Simulation var1);

    public void setSimulation(String var1);

    public void addSimulation(Simulation var1);

    public Simulation getSimulation();

    public JsonNode getSimulationJson();

    public void deleteSimulation();

    public Journal getJournal(int var1, int var2);

    public Journal getJournal(int var1, int var2, SortParams var3);

    public Journal searchJournal(Request var1);

    public void deleteJournal();

    public void deleteState();

    public StateView getState();

    public void setState(StateView var1);

    public void updateState(StateView var1);

    public DiffView getDiffs();

    public void cleanDiffs();

    public HoverflyInfoView getConfigInfo();

    public void setDestination(String var1);

    public void setMode(HoverflyMode var1);

    public void setMode(HoverflyMode var1, ModeArguments var2);

    public boolean getHealth();

    public static Builder custom() {
        return new Builder();
    }

    public static HoverflyClient createDefault() {
        return new Builder().build();
    }

    public static class Builder {
        private String scheme = "http";
        private String host = "localhost";
        private int port = 8888;
        private String authToken = null;
        private OkHttpClient client = null;

        Builder() {
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder withAuthToken() {
            this.authToken = System.getenv("HOVERFLY_AUTH_TOKEN");
            return this;
        }

        public Builder withHttpClient(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public HoverflyClient build() {
            if (this.client == null) {
                return new OkHttpHoverflyClient(this.scheme, this.host, this.port, this.authToken);
            }
            return new OkHttpHoverflyClient(this.scheme, this.host, this.port, this.client);
        }
    }
}

