/*
 * Decompiled with CFR 0.152.
 */
package io.socket.client;

import io.socket.client.Ack;
import io.socket.client.Manager;
import io.socket.client.On;
import io.socket.emitter.Emitter;
import io.socket.parser.Packet;
import io.socket.thread.EventThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Socket
extends Emitter {
    private static final Logger logger = Logger.getLogger(Socket.class.getName());
    public static final String EVENT_CONNECT = "connect";
    public static final String EVENT_CONNECTING = "connecting";
    public static final String EVENT_DISCONNECT = "disconnect";
    public static final String EVENT_ERROR = "error";
    public static final String EVENT_MESSAGE = "message";
    public static final String EVENT_CONNECT_ERROR = "connect_error";
    public static final String EVENT_CONNECT_TIMEOUT = "connect_timeout";
    public static final String EVENT_RECONNECT = "reconnect";
    public static final String EVENT_RECONNECT_ERROR = "reconnect_error";
    public static final String EVENT_RECONNECT_FAILED = "reconnect_failed";
    public static final String EVENT_RECONNECT_ATTEMPT = "reconnect_attempt";
    public static final String EVENT_RECONNECTING = "reconnecting";
    public static final String EVENT_PING = "ping";
    public static final String EVENT_PONG = "pong";
    protected static Map<String, Integer> events = new HashMap<String, Integer>(){
        {
            this.put(Socket.EVENT_CONNECT, 1);
            this.put(Socket.EVENT_CONNECT_ERROR, 1);
            this.put(Socket.EVENT_CONNECT_TIMEOUT, 1);
            this.put(Socket.EVENT_CONNECTING, 1);
            this.put(Socket.EVENT_DISCONNECT, 1);
            this.put(Socket.EVENT_ERROR, 1);
            this.put(Socket.EVENT_RECONNECT, 1);
            this.put(Socket.EVENT_RECONNECT_ATTEMPT, 1);
            this.put(Socket.EVENT_RECONNECT_FAILED, 1);
            this.put(Socket.EVENT_RECONNECT_ERROR, 1);
            this.put(Socket.EVENT_RECONNECTING, 1);
            this.put(Socket.EVENT_PING, 1);
            this.put(Socket.EVENT_PONG, 1);
        }
    };
    String id;
    private volatile boolean connected;
    private int ids;
    private String nsp;
    private Manager io;
    private String query;
    private Map<Integer, Ack> acks = new HashMap<Integer, Ack>();
    private Queue<On.Handle> subs;
    private final Queue<List<Object>> receiveBuffer = new LinkedList<List<Object>>();
    private final Queue<Packet<JSONArray>> sendBuffer = new LinkedList<Packet<JSONArray>>();

    public Socket(Manager io, String nsp, Manager.Options opts) {
        this.io = io;
        this.nsp = nsp;
        if (opts != null) {
            this.query = opts.query;
        }
    }

    private void subEvents() {
        if (this.subs != null) {
            return;
        }
        final Manager io = this.io;
        this.subs = new LinkedList<On.Handle>(){
            {
                this.add(On.on(io, "open", new Emitter.Listener(){

                    public void call(Object ... args) {
                        Socket.this.onopen();
                    }
                }));
                this.add(On.on(io, "packet", new Emitter.Listener(){

                    public void call(Object ... args) {
                        Socket.this.onpacket((Packet)args[0]);
                    }
                }));
                this.add(On.on(io, "close", new Emitter.Listener(){

                    public void call(Object ... args) {
                        Socket.this.onclose(args.length > 0 ? (String)args[0] : null);
                    }
                }));
            }
        };
    }

    public Socket open() {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Socket.this.connected || Socket.this.io.isReconnecting()) {
                    return;
                }
                Socket.this.subEvents();
                Socket.this.io.open();
                if (Manager.ReadyState.OPEN == ((Socket)Socket.this).io.readyState) {
                    Socket.this.onopen();
                }
                Socket.this.emit(Socket.EVENT_CONNECTING, new Object[0]);
            }
        });
        return this;
    }

    public Socket connect() {
        return this.open();
    }

    public Socket send(final Object ... args) {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                Socket.this.emit(Socket.EVENT_MESSAGE, args);
            }
        });
        return this;
    }

    public Emitter emit(final String event, final Object ... args) {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                Ack ack;
                Object[] _args;
                if (events.containsKey(event)) {
                    Socket.super.emit(event, args);
                    return;
                }
                int lastIndex = args.length - 1;
                if (args.length > 0 && args[lastIndex] instanceof Ack) {
                    _args = new Object[lastIndex];
                    for (int i = 0; i < lastIndex; ++i) {
                        _args[i] = args[i];
                    }
                    ack = (Ack)args[lastIndex];
                } else {
                    _args = args;
                    ack = null;
                }
                Socket.this.emit(event, _args, ack);
            }
        });
        return this;
    }

    public Emitter emit(final String event, final Object[] args, final Ack ack) {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                JSONArray jsonArgs = new JSONArray();
                jsonArgs.put((Object)event);
                if (args != null) {
                    for (Object arg : args) {
                        jsonArgs.put(arg);
                    }
                }
                Packet<JSONArray> packet = new Packet<JSONArray>(2, jsonArgs);
                if (ack != null) {
                    logger.fine(String.format("emitting packet with ack id %d", Socket.this.ids));
                    Socket.this.acks.put(Socket.this.ids, ack);
                    packet.id = Socket.this.ids++;
                }
                if (Socket.this.connected) {
                    Socket.this.packet(packet);
                } else {
                    Socket.this.sendBuffer.add(packet);
                }
            }
        });
        return this;
    }

    private void packet(Packet packet) {
        packet.nsp = this.nsp;
        this.io.packet(packet);
    }

    private void onopen() {
        logger.fine("transport is open - connecting");
        if (!"/".equals(this.nsp)) {
            if (this.query != null && !this.query.isEmpty()) {
                Packet packet = new Packet(0);
                packet.query = this.query;
                this.packet(packet);
            } else {
                this.packet(new Packet(0));
            }
        }
    }

    private void onclose(String reason) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("close (%s)", reason));
        }
        this.connected = false;
        this.id = null;
        this.emit(EVENT_DISCONNECT, reason);
    }

    private void onpacket(Packet<?> packet) {
        if (!this.nsp.equals(packet.nsp)) {
            return;
        }
        switch (packet.type) {
            case 0: {
                this.onconnect();
                break;
            }
            case 2: {
                Packet<JSONArray> p = packet;
                this.onevent(p);
                break;
            }
            case 5: {
                Packet<JSONArray> p = packet;
                this.onevent(p);
                break;
            }
            case 3: {
                Packet<JSONArray> p = packet;
                this.onack(p);
                break;
            }
            case 6: {
                Packet<JSONArray> p = packet;
                this.onack(p);
                break;
            }
            case 1: {
                this.ondisconnect();
                break;
            }
            case 4: {
                this.emit(EVENT_ERROR, packet.data);
            }
        }
    }

    private void onevent(Packet<JSONArray> packet) {
        ArrayList<Object> args = new ArrayList<Object>(Arrays.asList(Socket.toArray((JSONArray)packet.data)));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("emitting event %s", args));
        }
        if (packet.id >= 0) {
            logger.fine("attaching ack callback to event");
            args.add(this.ack(packet.id));
        }
        if (this.connected) {
            if (args.isEmpty()) {
                return;
            }
            String event = args.remove(0).toString();
            super.emit(event, args.toArray());
        } else {
            this.receiveBuffer.add(args);
        }
    }

    private Ack ack(final int id) {
        final Socket self = this;
        final boolean[] sent = new boolean[]{false};
        return new Ack(){

            @Override
            public void call(final Object ... args) {
                EventThread.exec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (sent[0]) {
                            return;
                        }
                        sent[0] = true;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(String.format("sending ack %s", args.length != 0 ? args : null));
                        }
                        JSONArray jsonArgs = new JSONArray();
                        for (Object arg : args) {
                            jsonArgs.put(arg);
                        }
                        Packet<JSONArray> packet = new Packet<JSONArray>(3, jsonArgs);
                        packet.id = id;
                        self.packet(packet);
                    }
                });
            }
        };
    }

    private void onack(Packet<JSONArray> packet) {
        Ack fn = this.acks.remove(packet.id);
        if (fn != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("calling ack %s with %s", packet.id, packet.data));
            }
            fn.call(Socket.toArray((JSONArray)packet.data));
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("bad ack %s", packet.id));
        }
    }

    private void onconnect() {
        this.connected = true;
        this.emitBuffered();
        super.emit(EVENT_CONNECT, new Object[0]);
    }

    private void emitBuffered() {
        Packet<JSONArray> packet;
        List<Object> data;
        while ((data = this.receiveBuffer.poll()) != null) {
            String event = (String)data.get(0);
            super.emit(event, data.toArray());
        }
        this.receiveBuffer.clear();
        while ((packet = this.sendBuffer.poll()) != null) {
            this.packet(packet);
        }
        this.sendBuffer.clear();
    }

    private void ondisconnect() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("server disconnect (%s)", this.nsp));
        }
        this.destroy();
        this.onclose("io server disconnect");
    }

    private void destroy() {
        if (this.subs != null) {
            for (On.Handle sub : this.subs) {
                sub.destroy();
            }
            this.subs = null;
        }
        this.io.destroy(this);
    }

    public Socket close() {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Socket.this.connected) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format("performing disconnect (%s)", Socket.this.nsp));
                    }
                    Socket.this.packet(new Packet(1));
                }
                Socket.this.destroy();
                if (Socket.this.connected) {
                    Socket.this.onclose("io client disconnect");
                }
            }
        });
        return this;
    }

    public Socket disconnect() {
        return this.close();
    }

    public Manager io() {
        return this.io;
    }

    public boolean connected() {
        return this.connected;
    }

    public String id() {
        return this.id;
    }

    private static Object[] toArray(JSONArray array) {
        int length = array.length();
        Object[] data = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object v;
            try {
                v = array.get(i);
            }
            catch (JSONException e) {
                logger.log(Level.WARNING, "An error occured while retrieving data from JSONArray", e);
                v = null;
            }
            data[i] = JSONObject.NULL.equals(v) ? null : v;
        }
        return data;
    }
}

