/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server.parser;

import io.socket.engineio.server.parser.Packet;
import io.socket.engineio.server.parser.Parser;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public final class ParserV4
implements Parser {
    public static final int PROTOCOL = 4;
    private static final String SEPARATOR = "\u001e";

    @Override
    public int getProtocolVersion() {
        return 4;
    }

    @Override
    public void encodePacket(Packet<?> packet, boolean supportsBinary, Parser.EncodeCallback<Object> callback) {
        if (packet.data instanceof byte[]) {
            ParserV4.encodeByteArray(packet, supportsBinary, callback);
        } else {
            String encoded = String.valueOf(PACKETS.get(packet.type));
            if (null != packet.data) {
                encoded = encoded + String.valueOf(packet.data);
            }
            callback.call(encoded);
        }
    }

    public static void encodeByteArray(Packet<byte[]> packet, boolean supportsBinary, Parser.EncodeCallback<Object> callback) {
        if (supportsBinary) {
            callback.call(packet.data);
        } else {
            String resultBuilder = "b" + Base64.getEncoder().encodeToString((byte[])packet.data);
            callback.call(resultBuilder);
        }
    }

    @Override
    public void encodePayload(List<Packet<?>> packets, boolean supportsBinary, Parser.EncodeCallback<Object> callback) {
        CharSequence[] encodedPackets = new String[packets.size()];
        int i = 0;
        while (i < encodedPackets.length) {
            Packet<?> packet = packets.get(i);
            int packetIdx = i++;
            this.encodePacket(packet, false, arg_0 -> ParserV4.lambda$encodePayload$0((String[])encodedPackets, packetIdx, arg_0));
        }
        callback.call(String.join((CharSequence)SEPARATOR, encodedPackets));
    }

    @Override
    public void decodePayload(Object data, Parser.DecodePayloadCallback<Object> callback) {
        assert (callback != null);
        ArrayList packets = new ArrayList();
        if (data instanceof String) {
            String[] encodedPackets;
            for (String encodedPacket : encodedPackets = ((String)data).split(SEPARATOR)) {
                Packet<?> packet = this.decodePacket(encodedPacket);
                packets.add(packet);
                if (!packet.type.equals("error")) {
                    continue;
                }
                break;
            }
        } else {
            throw new IllegalArgumentException("data must be a String");
        }
        for (int i = 0; i < packets.size(); ++i) {
            if (callback.call((Packet)packets.get(i), i, packets.size())) continue;
            return;
        }
    }

    @Override
    public Packet<?> decodePacket(Object data) {
        if (data == null) {
            return ERROR_PACKET;
        }
        if (data instanceof String) {
            String stringData = (String)data;
            if (stringData.charAt(0) == 'b') {
                Packet packet = new Packet("message");
                packet.data = Base64.getDecoder().decode(stringData.substring(1));
                return packet;
            }
            Packet packet = new Packet((String)PACKETS_REVERSE.get(Integer.parseInt(String.valueOf(stringData.charAt(0)))));
            packet.data = stringData.substring(1);
            return packet;
        }
        if (data instanceof byte[]) {
            return new Packet<byte[]>("message", (byte[])data);
        }
        throw new IllegalArgumentException("Invalid type for data: " + data.getClass().getSimpleName());
    }

    private static /* synthetic */ void lambda$encodePayload$0(String[] encodedPackets, int packetIdx, Object data) {
        encodedPackets[packetIdx] = (String)data;
    }
}

