/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.client.transports;

import io.socket.engineio.client.Transport;
import io.socket.engineio.client.transports.PollingXHR;
import io.socket.engineio.parser.Packet;
import io.socket.engineio.parser.Parser;
import io.socket.parseqs.ParseQS;
import io.socket.thread.EventThread;
import io.socket.utf8.UTF8Exception;
import io.socket.yeast.Yeast;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.Route;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;

public class WebSocket
extends Transport {
    public static final String NAME = "websocket";
    private static final Logger logger = Logger.getLogger(PollingXHR.class.getName());
    private okhttp3.ws.WebSocket ws;
    private WebSocketCall wsCall;

    public WebSocket(Transport.Options opts) {
        super(opts);
        this.name = NAME;
    }

    @Override
    protected void doOpen() {
        TreeMap headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.emit("requestHeaders", headers);
        final WebSocket self = this;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS);
        if (this.sslContext != null) {
            SSLSocketFactory factory = this.sslContext.getSocketFactory();
            clientBuilder.sslSocketFactory(factory);
        }
        if (this.hostnameVerifier != null) {
            clientBuilder.hostnameVerifier(this.hostnameVerifier);
        }
        if (this.proxy != null) {
            clientBuilder.proxy(this.proxy);
        }
        if (this.proxyLogin != null && !this.proxyLogin.isEmpty()) {
            final String credentials = Credentials.basic((String)this.proxyLogin, (String)this.proxyPassword);
            clientBuilder.proxyAuthenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    return response.request().newBuilder().header("Proxy-Authorization", credentials).build();
                }
            });
        }
        Request.Builder builder = new Request.Builder().url(this.uri());
        for (Map.Entry entry : headers.entrySet()) {
            for (String v : (List)entry.getValue()) {
                builder.addHeader((String)entry.getKey(), v);
            }
        }
        Request request = builder.build();
        OkHttpClient client = clientBuilder.build();
        this.wsCall = WebSocketCall.create((OkHttpClient)client, (Request)request);
        this.wsCall.enqueue(new WebSocketListener(){

            public void onOpen(okhttp3.ws.WebSocket webSocket, Response response) {
                WebSocket.this.ws = webSocket;
                final Map headers = response.headers().toMultimap();
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        self.emit("responseHeaders", headers);
                        self.onOpen();
                    }
                });
            }

            public void onMessage(final ResponseBody responseBody) throws IOException {
                Object data = null;
                if (responseBody.contentType() == okhttp3.ws.WebSocket.TEXT) {
                    data = responseBody.string();
                } else if (responseBody.contentType() == okhttp3.ws.WebSocket.BINARY) {
                    data = responseBody.source().readByteArray();
                } else {
                    EventThread.exec(new Runnable(){

                        @Override
                        public void run() {
                            self.onError("Unknown payload type: " + responseBody.contentType(), new IllegalStateException());
                        }
                    });
                }
                responseBody.source().close();
                final String finalData = data;
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        if (finalData == null) {
                            return;
                        }
                        if (finalData instanceof String) {
                            self.onData((String)finalData);
                        } else {
                            self.onData((byte[])finalData);
                        }
                    }
                });
            }

            public void onPong(Buffer payload) {
            }

            public void onClose(int code, String reason) {
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        self.onClose();
                    }
                });
            }

            public void onFailure(final IOException e, Response response) {
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        self.onError("websocket error", e);
                    }
                });
            }
        });
        client.dispatcher().executorService().shutdown();
    }

    @Override
    protected void write(Packet[] packets) throws UTF8Exception {
        final WebSocket self = this;
        this.writable = false;
        final Runnable done = new Runnable(){

            @Override
            public void run() {
                EventThread.nextTick(new Runnable(){

                    @Override
                    public void run() {
                        self.writable = true;
                        self.emit("drain", new Object[0]);
                    }
                });
            }
        };
        final int[] total = new int[]{packets.length};
        for (Packet packet : packets) {
            if (this.readyState != Transport.ReadyState.OPENING && this.readyState != Transport.ReadyState.OPEN) break;
            Parser.encodePacket(packet, new Parser.EncodeCallback(){

                public void call(Object packet) {
                    try {
                        if (packet instanceof String) {
                            self.ws.sendMessage(RequestBody.create((MediaType)okhttp3.ws.WebSocket.TEXT, (String)((String)packet)));
                        } else if (packet instanceof byte[]) {
                            self.ws.sendMessage(RequestBody.create((MediaType)okhttp3.ws.WebSocket.BINARY, (byte[])((byte[])packet)));
                        }
                    }
                    catch (IOException e) {
                        logger.fine("websocket closed before onclose event");
                        WebSocket.this.doClose();
                    }
                    total[0] = total[0] - 1;
                    if (0 == total[0]) {
                        done.run();
                    }
                }
            });
        }
    }

    @Override
    protected void onClose() {
        super.onClose();
    }

    @Override
    protected void doClose() {
        if (this.ws != null) {
            try {
                this.ws.close(1000, "");
            }
            catch (IOException iOException) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.wsCall != null) {
            this.wsCall.cancel();
        }
    }

    protected String uri() {
        String derivedQuery;
        HashMap<String, String> query = this.query;
        if (query == null) {
            query = new HashMap<String, String>();
        }
        String schema = this.secure ? "wss" : "ws";
        String port = "";
        if (this.port > 0 && ("wss".equals(schema) && this.port != 443 || "ws".equals(schema) && this.port != 80)) {
            port = ":" + this.port;
        }
        if (this.timestampRequests) {
            query.put(this.timestampParam, Yeast.yeast());
        }
        if ((derivedQuery = ParseQS.encode(query)).length() > 0) {
            derivedQuery = "?" + derivedQuery;
        }
        boolean ipv6 = this.hostname.contains(":");
        return schema + "://" + (ipv6 ? "[" + this.hostname + "]" : this.hostname) + port + this.path + derivedQuery;
    }
}

