package io.smallrye.openapi.runtime.util;

import java.util.Locale;
import java.io.Serializable;
import java.lang.NullPointerException;
import org.jboss.jandex.PrimitiveType;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
public class UtilMessages_$bundle implements UtilMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected UtilMessages_$bundle() {}
    public static final UtilMessages_$bundle INSTANCE = new UtilMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String refTypeNotNull$str() {
        return "SROAP08000: ReferenceType must not be null";
    }
    @Override
    public final NullPointerException refTypeNotNull() {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), refTypeNotNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unknownPrimitive$str() {
        return "SROAP08001: Unknown primitive: %s";
    }
    @Override
    public final IllegalArgumentException unknownPrimitive(final PrimitiveType primitive) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownPrimitive$str(), primitive));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
