package io.smallrye.openapi.runtime.scanner.spi;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.lang.String;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class ScannerSPIMessages_$bundle implements ScannerSPIMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected ScannerSPIMessages_$bundle() {}
    public static final ScannerSPIMessages_$bundle INSTANCE = new ScannerSPIMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String duplicateOperationId$str() {
        return "SROAP07950: Duplicate operationId: %s produced by Class: %s, Method: %s and Class: %s, Method: %s";
    }
    @Override
    public final IllegalStateException duplicateOperationId(final String operationId, final String className, final String method, final String conflictingClassName, final String conflictingMethod) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), duplicateOperationId$str(), operationId, className, method, conflictingClassName, conflictingMethod));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
}
