/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.ApiMessages;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.api.util.FilterUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.api.util.ServersUtil;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;

public class OpenApiDocument {
    public static final OpenApiDocument INSTANCE = new OpenApiDocument();
    private transient OpenApiConfig config;
    private transient OpenAPI annotationsModel;
    private transient OpenAPI readerModel;
    private transient OpenAPI staticFileModel;
    private transient OASFilter filter;
    private transient String archiveName;
    private transient OpenAPI model;

    private OpenApiDocument() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenAPI get() {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            if (this.model == null) {
                throw ApiMessages.msg.modelNotInitialized();
            }
            return this.model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(OpenAPI model) {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            this.model = model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            this.model = null;
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSet() {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            return this.model != null;
        }
    }

    public synchronized void config(OpenApiConfig config) {
        this.set(() -> {
            this.config = config;
        });
    }

    public void modelFromAnnotations(OpenAPI model) {
        this.set(() -> {
            this.annotationsModel = model;
        });
    }

    public void modelFromReader(OpenAPI model) {
        this.set(() -> {
            this.readerModel = model;
        });
    }

    public void modelFromStaticFile(OpenAPI model) {
        this.set(() -> {
            this.staticFileModel = model;
        });
    }

    public void filter(OASFilter filter) {
        this.set(() -> {
            this.filter = filter;
        });
    }

    public void archiveName(String archiveName) {
        this.set(() -> {
            this.archiveName = archiveName;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            if (this.model != null) {
                this.modelAlreadyInitialized();
            }
            if (this.config == null) {
                throw ApiMessages.msg.configMustBeSet();
            }
            OpenAPI merged = this.readerModel;
            merged = MergeUtil.mergeObjects(merged, this.staticFileModel);
            merged = MergeUtil.mergeObjects(merged, this.annotationsModel);
            if ((merged = this.filterModel(merged)) == null) {
                merged = new OpenAPIImpl();
                merged.setOpenapi("3.0.1");
            }
            if (merged.getPaths() == null) {
                merged.setPaths((Paths)new PathsImpl());
            }
            if (merged.getInfo() == null) {
                merged.setInfo((Info)new InfoImpl());
            }
            if (merged.getInfo().getTitle() == null) {
                merged.getInfo().setTitle((this.archiveName == null ? "Generated" : this.archiveName) + " API");
            }
            if (merged.getInfo().getVersion() == null) {
                merged.getInfo().setVersion("1.0");
            }
            ServersUtil.configureServers(this.config, merged);
            this.model = merged;
            this.clear();
        }
    }

    private OpenAPI filterModel(OpenAPI model) {
        if (model == null || this.filter == null) {
            return model;
        }
        return FilterUtil.applyFilter(this.filter, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(Runnable action) {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            if (this.model != null) {
                this.modelAlreadyInitialized();
            }
            action.run();
        }
    }

    private void modelAlreadyInitialized() {
        throw ApiMessages.msg.modelAlreadyInitialized();
    }

    private void clear() {
        this.config = null;
        this.annotationsModel = null;
        this.readerModel = null;
        this.staticFileModel = null;
        this.filter = null;
        this.archiveName = null;
    }
}

