/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.validation;

import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.execution.ResultPath;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.SourceLocation;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.validation.BeanValidationError;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.graphql.Source;

public class BeanValidationUtil {
    public static DataFetcherResult.Builder<Object> addConstraintViolationsToDataFetcherResult(Set<ConstraintViolation<?>> violations, Method method, DataFetcherResult.Builder<Object> builder, DataFetchingEnvironment dfe) {
        ResultPath resultPath = dfe.getExecutionStepInfo().getPath();
        RequestNodeBuilder requestNodeBuilder = new RequestNodeBuilder(method, dfe);
        List<SourceLocation> sourceLocations = violations.stream().map(requestNodeBuilder::build).flatMap(Collection::stream).distinct().map(Node::getSourceLocation).collect(Collectors.toList());
        return builder.error((GraphQLError)new BeanValidationError(violations, resultPath, sourceLocations));
    }

    static class RequestNodeBuilder {
        private final Method method;
        private final DataFetchingEnvironment dfe;

        RequestNodeBuilder(Method method, DataFetchingEnvironment dfe) {
            this.method = method;
            this.dfe = dfe;
        }

        List<NamedNode<?>> build(ConstraintViolation<?> violation) {
            Iterator violationNodes = violation.getPropertyPath().iterator();
            return Arrays.asList(this.methodNode((Path.Node)violationNodes.next()), this.requestedArgument((Path.Node)violationNodes.next()));
        }

        private Field methodNode(Path.Node methodNode) {
            assert (this.dfe.getFieldDefinition().getName().equals(methodNode.getName())) : "expected first violation path item " + methodNode.getName() + " to be the method name field definition " + this.dfe.getFieldDefinition().getName();
            return this.dfe.getField();
        }

        private Argument requestedArgument(Path.Node node) {
            String graphQLArgumentName = ((GraphQLArgument)this.dfe.getFieldDefinition().getArguments().get(this.parameterIndex(node.getName()))).getName();
            Field requestedField = this.dfe.getMergedField().getSingleField();
            return requestedField.getArguments().stream().filter(argument -> argument.getName().equals(graphQLArgumentName)).findFirst().orElseThrow(() -> new AssertionError((Object)("expected field " + graphQLArgumentName + " in " + String.valueOf(requestedField.getArguments()))));
        }

        private int parameterIndex(String name) {
            Parameter[] parameters = this.method.getParameters();
            int index = 0;
            for (Parameter parameter : parameters) {
                boolean isAnnotatedWithSource;
                if (name.equals(parameter.getName())) {
                    return index;
                }
                boolean isContext = parameter.getType().isAssignableFrom(Context.class);
                boolean bl = isAnnotatedWithSource = parameter.getAnnotation(Source.class) != null;
                if (isContext || isAnnotatedWithSource) continue;
                ++index;
            }
            throw new AssertionError((Object)("expected parameter " + name + " in " + String.valueOf(this.method)));
        }
    }
}

