/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar.custom;

import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.CustomStringScalar;
import io.smallrye.graphql.spi.ClassloadingService;
import java.lang.reflect.InvocationTargetException;

public class StringCoercing
implements Coercing<Object, String> {
    private final Class<? extends CustomStringScalar> customScalarClass;

    public StringCoercing(String customScalarClass) {
        ClassloadingService classloadingService = ClassloadingService.get();
        this.customScalarClass = classloadingService.loadClass(customScalarClass);
    }

    private CustomStringScalar newInstance(String graphqlPrimitiveValue) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return graphqlPrimitiveValue == null ? null : this.customScalarClass.getConstructor(String.class).newInstance(graphqlPrimitiveValue);
    }

    private static String typeName(Object input) {
        if (input == null) {
            return "null";
        }
        return input.getClass().getSimpleName();
    }

    private CustomStringScalar convertImpl(Object input) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (input instanceof String) {
            return this.newInstance((String)input);
        }
        if (input.getClass().isAssignableFrom(this.customScalarClass)) {
            return (CustomStringScalar)input;
        }
        throw new RuntimeException("Unable to convert null input.");
    }

    public String serialize(Object input) throws CoercingSerializeException {
        CustomStringScalar result;
        try {
            result = this.convertImpl(input);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CoercingSerializeException("Unable to serialize object.", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingSerializeException("String or class extending " + String.valueOf(this.customScalarClass), StringCoercing.typeName(input), null);
        }
        return result.stringValueForSerialization();
    }

    public Object parseValue(Object input) throws CoercingParseValueException {
        CustomStringScalar result;
        try {
            result = this.convertImpl(input);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CoercingParseValueException("Unable to parse value: " + String.valueOf(input), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingParseValueException("String or class extending " + String.valueOf(this.customScalarClass), StringCoercing.typeName(input), null);
        }
        return result;
    }

    public Object parseLiteral(Object input) throws CoercingParseLiteralException {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseLiteralException("Expected a String AST type object but was '" + StringCoercing.typeName(input) + "'.");
        }
        try {
            return this.newInstance(((StringValue)input).getValue());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CoercingParseLiteralException("Unable to parse literal: " + String.valueOf(input), (Throwable)e);
        }
    }

    public Value<?> valueToLiteral(Object input) {
        String s = this.serialize(input);
        return StringValue.newStringValue((String)s).build();
    }
}

