/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import graphql.execution.Async;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DelegatingDataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import io.smallrye.graphql.bootstrap.TypeFieldWrapper;
import io.smallrye.graphql.spi.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class FederationDataFetcher
implements DataFetcher<CompletableFuture<List<Object>>> {
    public static final String TYPENAME = "__typename";
    private final GraphQLObjectType queryType;
    private final GraphQLObjectType resolversType;
    private final GraphQLCodeRegistry codeRegistry;
    private final ConcurrentHashMap<TypeAndArgumentNames, TypeFieldWrapper> cache = new ConcurrentHashMap();

    public FederationDataFetcher(GraphQLObjectType resolversType, GraphQLObjectType queryType, GraphQLCodeRegistry codeRegistry) {
        this.resolversType = resolversType;
        this.queryType = queryType;
        this.codeRegistry = codeRegistry;
    }

    public CompletableFuture<List<Object>> get(DataFetchingEnvironment environment) throws Exception {
        List reps = (List)environment.getArgument("representations");
        List representations = IntStream.range(0, reps.size()).boxed().map(i -> new Representation((Map)reps.get((int)i), (int)i)).collect(Collectors.toList());
        if (Config.get().isFederationBatchResolvingEnabled()) {
            Map<TypeAndArgumentNames, List<Representation>> repsWithPositionPerType = representations.stream().collect(Collectors.groupingBy(r -> r.typeAndArgumentNames));
            Map fieldDefinitions = repsWithPositionPerType.keySet().stream().collect(Collectors.toMap(Function.identity(), typeAndArgumentNames -> this.cache.computeIfAbsent((TypeAndArgumentNames)typeAndArgumentNames, type -> Objects.requireNonNullElseGet(this.findBatchFieldDefinition((TypeAndArgumentNames)type), () -> this.findFieldDefinition((TypeAndArgumentNames)type)))));
            return FederationDataFetcher.sequence(repsWithPositionPerType.entrySet().stream().map(e -> {
                TypeFieldWrapper fieldDefinition = (TypeFieldWrapper)fieldDefinitions.get(e.getKey());
                if (this.getGraphqlTypeFromField(fieldDefinition.getField()) instanceof GraphQLList) {
                    return this.executeList(fieldDefinition, environment, (List)e.getValue());
                }
                return FederationDataFetcher.sequence(((List)e.getValue()).stream().map(r -> this.execute(fieldDefinition, environment, (Representation)r)).collect(Collectors.toList()));
            }).collect(Collectors.toList())).thenApply(l -> l.stream().flatMap(Collection::stream).sorted(Comparator.comparingInt(r -> r.position)).map(r -> r.Result).collect(Collectors.toList()));
        }
        return FederationDataFetcher.sequence(representations.stream().map(rep -> this.fetchEntities(environment, (Representation)rep, this.cache.computeIfAbsent(rep.typeAndArgumentNames, this::findFieldDefinition))).collect(Collectors.toList())).thenApply(l -> l.stream().map(r -> r.Result).collect(Collectors.toList()));
    }

    private TypeFieldWrapper findRecursiveFieldDefinition(TypeAndArgumentNames typeAndArgumentNames, GraphQLFieldDefinition field, BiFunction<GraphQLFieldDefinition, String, Boolean> matchesReturnType) {
        if (field.getType() instanceof GraphQLObjectType) {
            for (GraphQLSchemaElement child : field.getType().getChildren()) {
                if (!(child instanceof GraphQLFieldDefinition)) continue;
                GraphQLFieldDefinition definition = (GraphQLFieldDefinition)child;
                if (matchesReturnType.apply(definition, typeAndArgumentNames.type).booleanValue() && this.matchesArguments(typeAndArgumentNames, definition)) {
                    return new TypeFieldWrapper((GraphQLObjectType)field.getType(), definition);
                }
                if (!(definition.getType() instanceof GraphQLObjectType)) continue;
                return this.findRecursiveFieldDefinition(typeAndArgumentNames, definition, matchesReturnType);
            }
        }
        return null;
    }

    private TypeFieldWrapper findBatchFieldDefinition(TypeAndArgumentNames typeAndArgumentNames) {
        for (GraphQLFieldDefinition field : this.resolversType.getFields()) {
            if (!this.matchesReturnTypeList(field, typeAndArgumentNames.type) || !this.matchesArguments(typeAndArgumentNames, field)) continue;
            return new TypeFieldWrapper(this.resolversType, field);
        }
        for (GraphQLFieldDefinition field : this.queryType.getFields()) {
            if (!this.matchesReturnTypeList(field, typeAndArgumentNames.type) || !this.matchesArguments(typeAndArgumentNames, field)) continue;
            return new TypeFieldWrapper(this.queryType, field);
        }
        for (GraphQLFieldDefinition field : this.queryType.getFields()) {
            TypeFieldWrapper typeFieldWrapper = this.findRecursiveFieldDefinition(typeAndArgumentNames, field, this::matchesReturnTypeList);
            if (typeFieldWrapper == null) continue;
            return typeFieldWrapper;
        }
        return null;
    }

    private TypeFieldWrapper findFieldDefinition(TypeAndArgumentNames typeAndArgumentNames) {
        for (GraphQLFieldDefinition field : this.resolversType.getFields()) {
            if (!this.matchesReturnType(field, typeAndArgumentNames.type) || !this.matchesArguments(typeAndArgumentNames, field)) continue;
            return new TypeFieldWrapper(this.resolversType, field);
        }
        for (GraphQLFieldDefinition field : this.queryType.getFields()) {
            if (!this.matchesReturnType(field, typeAndArgumentNames.type) || !this.matchesArguments(typeAndArgumentNames, field)) continue;
            return new TypeFieldWrapper(this.queryType, field);
        }
        for (GraphQLFieldDefinition field : this.queryType.getFields()) {
            TypeFieldWrapper typeFieldWrapper = this.findRecursiveFieldDefinition(typeAndArgumentNames, field, this::matchesReturnType);
            if (typeFieldWrapper == null) continue;
            return typeFieldWrapper;
        }
        throw new RuntimeException("no query found for " + typeAndArgumentNames.type + " by " + String.valueOf(typeAndArgumentNames.argumentNames));
    }

    private CompletableFuture<ResultObject> fetchEntities(DataFetchingEnvironment env, Representation representation, TypeFieldWrapper wrapper) {
        return this.execute(wrapper, env, representation);
    }

    private boolean matchesReturnType(GraphQLFieldDefinition field, String typename) {
        GraphQLType returnType = this.getGraphqlTypeFromField(field);
        return returnType instanceof GraphQLNamedSchemaElement && ((GraphQLNamedSchemaElement)returnType).getName().equals(typename);
    }

    private boolean matchesReturnTypeList(GraphQLFieldDefinition field, String typename) {
        GraphQLType listType = this.getGraphqlTypeFromField(field);
        if (listType instanceof GraphQLList) {
            GraphQLType returnType = ((GraphQLList)listType).getOriginalWrappedType();
            return returnType instanceof GraphQLNamedSchemaElement && ((GraphQLNamedSchemaElement)returnType).getName().equals(typename);
        }
        return false;
    }

    private GraphQLType getGraphqlTypeFromField(GraphQLFieldDefinition field) {
        GraphQLOutputType type = field.getType();
        if (type instanceof GraphQLNonNull) {
            type = ((GraphQLNonNull)type).getOriginalWrappedType();
        }
        return type;
    }

    private boolean matchesArguments(TypeAndArgumentNames typeAndArgumentNames, GraphQLFieldDefinition field) {
        Set argumentNames = field.getArguments().stream().map(GraphQLArgument::getName).collect(Collectors.toSet());
        return argumentNames.equals(typeAndArgumentNames.argumentNames);
    }

    private CompletableFuture<List<ResultObject>> executeList(TypeFieldWrapper wrapper, DataFetchingEnvironment env, List<Representation> representations) {
        DataFetcher dataFetcher = this.codeRegistry.getDataFetcher(wrapper.getType(), wrapper.getField());
        HashMap arguments = new HashMap();
        representations.forEach(r -> r.arguments.forEach((argumentName, argumentValue) -> arguments.computeIfAbsent(argumentName, ignore -> new ArrayList()).add(argumentValue)));
        final HashMap argumentsAsObject = new HashMap(arguments);
        DelegatingDataFetchingEnvironment argsEnv = new DelegatingDataFetchingEnvironment(env){

            public Map<String, Object> getArguments() {
                return argumentsAsObject;
            }

            public boolean containsArgument(String name) {
                return argumentsAsObject.containsKey(name);
            }

            public <T> T getArgument(String name) {
                return (T)argumentsAsObject.get(name);
            }

            public <T> T getArgumentOrDefault(String name, T defaultValue) {
                return this.containsArgument(name) ? this.getArgument(name) : defaultValue;
            }
        };
        try {
            return Async.toCompletableFuture((Object)dataFetcher.get((DataFetchingEnvironment)argsEnv)).thenApply(results -> {
                List resultList;
                if (results instanceof DataFetcherResult) {
                    resultList = (List)((DataFetcherResult)results).getData();
                } else if (results instanceof List) {
                    resultList = (List)results;
                } else {
                    throw new IllegalStateException("Result of batchDataFetcher for Field " + wrapper.getField().getName() + " needs to be a list" + results.toString());
                }
                if (resultList.size() != representations.size()) {
                    throw new IllegalStateException("Size of result list " + resultList.size() + " needs to be equal to size of arguments " + representations.size());
                }
                return IntStream.range(0, resultList.size()).boxed().map(i -> new ResultObject(resultList.get((int)i), ((Representation)representations.get((int)i.intValue())).position)).collect(Collectors.toList());
            });
        }
        catch (Exception e) {
            throw new RuntimeException("can't fetch data from " + String.valueOf(wrapper.getField()), e);
        }
    }

    private CompletableFuture<ResultObject> execute(TypeFieldWrapper wrapper, DataFetchingEnvironment env, final Representation representation) {
        DataFetcher dataFetcher = this.codeRegistry.getDataFetcher(wrapper.getType(), wrapper.getField());
        DelegatingDataFetchingEnvironment argsEnv = new DelegatingDataFetchingEnvironment(env){

            public Map<String, Object> getArguments() {
                return representation.arguments;
            }

            public boolean containsArgument(String name) {
                return representation.arguments.containsKey(name);
            }

            public <T> T getArgument(String name) {
                return (T)representation.arguments.get(name);
            }

            public <T> T getArgumentOrDefault(String name, T defaultValue) {
                return this.containsArgument(name) ? this.getArgument(name) : defaultValue;
            }
        };
        try {
            return Async.toCompletableFuture((Object)dataFetcher.get((DataFetchingEnvironment)argsEnv)).thenApply(o -> new ResultObject(o, representation.position));
        }
        catch (Exception e) {
            throw new RuntimeException("can't fetch data from " + String.valueOf(wrapper.getField()), e);
        }
    }

    static <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> com) {
        return CompletableFuture.allOf(com.toArray(new CompletableFuture[0])).thenApply(v -> com.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    static class TypeAndArgumentNames {
        final Set<String> argumentNames;
        final String type;

        public TypeAndArgumentNames(Set<String> argumentNames, String type) {
            this.argumentNames = argumentNames;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeAndArgumentNames that = (TypeAndArgumentNames)o;
            return Objects.equals(this.argumentNames, that.argumentNames) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.argumentNames, this.type);
        }
    }

    static class Representation {
        final Map<String, Object> arguments;
        final int position;
        final TypeAndArgumentNames typeAndArgumentNames;

        public Representation(Map<String, Object> arguments, int position) {
            this.arguments = arguments;
            this.position = position;
            HashSet<String> argumentNames = new HashSet<String>(arguments.keySet());
            argumentNames.remove(FederationDataFetcher.TYPENAME);
            this.typeAndArgumentNames = new TypeAndArgumentNames(argumentNames, (String)arguments.get(FederationDataFetcher.TYPENAME));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Representation that = (Representation)o;
            return this.position == that.position && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.typeAndArgumentNames, that.typeAndArgumentNames);
        }

        public int hashCode() {
            return Objects.hash(this.arguments, this.position, this.typeAndArgumentNames);
        }
    }

    static class ResultObject {
        final Object Result;
        final int position;

        public ResultObject(Object result, int position) {
            this.Result = result;
            this.position = position;
        }
    }
}

