/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.model;

import io.smallrye.graphql.schema.model.CustomScalarType;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.DirectiveType;
import io.smallrye.graphql.schema.model.EnumType;
import io.smallrye.graphql.schema.model.ErrorInfo;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.Namespace;
import io.smallrye.graphql.schema.model.NamespaceContainer;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Scalars;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.schema.model.UnionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Schema
implements Serializable {
    private String description;
    private Set<Operation> queries = new HashSet<Operation>();
    private Set<Operation> mutations = new HashSet<Operation>();
    private Set<Operation> subscriptions = new HashSet<Operation>();
    private Set<Operation> resolvers = new HashSet<Operation>();
    private Map<String, NamespaceContainer> namespacedQueries = new HashMap<String, NamespaceContainer>();
    private Map<String, NamespaceContainer> namespacedMutations = new HashMap<String, NamespaceContainer>();
    private List<CustomScalarType> customScalarTypes = new ArrayList<CustomScalarType>();
    private List<DirectiveType> directiveTypes = new ArrayList<DirectiveType>();
    private Map<String, InputType> inputs = new HashMap<String, InputType>();
    private Map<String, Type> types = new HashMap<String, Type>();
    private Map<String, Type> interfaces = new HashMap<String, Type>();
    private Map<String, UnionType> unions = new HashMap<String, UnionType>();
    private Map<String, EnumType> enums = new HashMap<String, EnumType>();
    private Map<String, ErrorInfo> errors = new HashMap<String, ErrorInfo>();
    private Map<String, String> wrappedDataFetchers = new HashMap<String, String>();
    private Map<String, String> fieldDataFetchers = new HashMap<String, String>();
    private List<DirectiveInstance> directiveInstances = new ArrayList<DirectiveInstance>();

    public Map<String, NamespaceContainer> getNamespacedQueries() {
        return this.namespacedQueries;
    }

    public void setNamespacedQueries(Map<String, NamespaceContainer> namespacedQueries) {
        this.namespacedQueries = namespacedQueries;
    }

    public Map<String, NamespaceContainer> getNamespacedMutations() {
        return this.namespacedMutations;
    }

    public Set<Operation> getAllOperations() {
        HashSet<Operation> operations = new HashSet<Operation>();
        operations.addAll(this.queries);
        operations.addAll(this.mutations);
        operations.addAll(this.subscriptions);
        operations.addAll(this.getAllNamespacedQueryOperations());
        operations.addAll(this.getAllNamespacedMutationOperations());
        return operations;
    }

    public Set<Operation> getAllNamespacedQueryOperations() {
        return this.namespacedQueries.values().stream().map(NamespaceContainer::getAllOperations).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<Operation> getAllNamespacedMutationOperations() {
        return this.namespacedMutations.values().stream().map(NamespaceContainer::getAllOperations).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public void setNamespacedMutations(Map<String, NamespaceContainer> namespacedMutations) {
        this.namespacedMutations = namespacedMutations;
    }

    public Set<Operation> getQueries() {
        return this.queries;
    }

    public void setQueries(Set<Operation> queries) {
        this.queries = queries;
    }

    public void addQuery(Operation query) {
        this.queries.add(query);
    }

    public boolean hasOperations() {
        return this.hasQueries() || this.hasNamespaceQueries() || this.hasMutations() || this.hasNamespaceMutations() || this.hasSubscriptions() || this.hasResolvers();
    }

    public boolean hasQueries() {
        return !this.queries.isEmpty();
    }

    public Set<Operation> getMutations() {
        return this.mutations;
    }

    public void setMutations(Set<Operation> mutations) {
        this.mutations = mutations;
    }

    public void addMutation(Operation mutation) {
        this.mutations.add(mutation);
    }

    public boolean hasMutations() {
        return !this.mutations.isEmpty();
    }

    public Set<Operation> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(Set<Operation> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public void addSubscription(Operation subscription) {
        this.subscriptions.add(subscription);
    }

    public boolean hasSubscriptions() {
        return !this.subscriptions.isEmpty();
    }

    public Set<Operation> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(Set<Operation> resolvers) {
        this.resolvers = resolvers;
    }

    public void addResolver(Operation resolver) {
        this.resolvers.add(resolver);
    }

    public boolean hasResolvers() {
        return !this.resolvers.isEmpty();
    }

    public Map<String, InputType> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, InputType> inputs) {
        this.inputs = inputs;
    }

    public void addInput(InputType input) {
        this.inputs.put(input.getName(), input);
    }

    public boolean containsInput(String name) {
        return this.inputs.containsKey(name);
    }

    public boolean hasInputs() {
        return !this.inputs.isEmpty();
    }

    public Map<String, Type> getTypes() {
        return this.types;
    }

    public void setTypes(Map<String, Type> types) {
        this.types = types;
    }

    public void addType(Type type) {
        this.types.put(type.getName(), type);
    }

    public boolean containsType(String name) {
        return this.types.containsKey(name);
    }

    public boolean hasTypes() {
        return !this.types.isEmpty();
    }

    public Map<String, Type> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Map<String, Type> interfaces) {
        this.interfaces = interfaces;
    }

    public void addInterface(Type interfaceType) {
        if (interfaceType.getFields() != null && !interfaceType.getFields().isEmpty()) {
            this.interfaces.put(interfaceType.getName(), interfaceType);
        }
    }

    public boolean containsInterface(String name) {
        return this.interfaces.containsKey(name);
    }

    public boolean hasInterfaces() {
        return !this.interfaces.isEmpty();
    }

    public Map<String, UnionType> getUnions() {
        return this.unions;
    }

    public void setUnions(Map<String, UnionType> unions) {
        this.unions = unions;
    }

    public void addUnion(UnionType unionType) {
        this.unions.put(unionType.getName(), unionType);
    }

    public boolean containsUnion(String name) {
        return this.unions.containsKey(name);
    }

    public boolean hasUnions() {
        return !this.unions.isEmpty();
    }

    public Map<String, EnumType> getEnums() {
        return this.enums;
    }

    public void setEnums(Map<String, EnumType> enums) {
        this.enums = enums;
    }

    public void addEnum(EnumType enumType) {
        this.enums.put(enumType.getName(), enumType);
    }

    public boolean containsEnum(String name) {
        return this.enums.containsKey(name);
    }

    public boolean hasEnums() {
        return !this.enums.isEmpty();
    }

    public Map<String, ErrorInfo> getErrors() {
        return this.errors;
    }

    public void setErrors(Map<String, ErrorInfo> errors) {
        this.errors = errors;
    }

    public void addError(ErrorInfo error) {
        this.errors.put(error.getClassName(), error);
    }

    public boolean containsError(String classname) {
        return this.errors.containsKey(classname);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Map<String, String> getWrappedDataFetchers() {
        return this.wrappedDataFetchers;
    }

    public void setWrappedDataFetchers(Map<String, String> wrappedDataFetchers) {
        this.wrappedDataFetchers = wrappedDataFetchers;
    }

    public void addWrappedDataFetcher(String forReturn, String className) {
        this.wrappedDataFetchers.put(forReturn, className);
    }

    public boolean hasWrappedDataFetchers() {
        return !this.wrappedDataFetchers.isEmpty();
    }

    public Map<String, String> getFieldDataFetchers() {
        return this.fieldDataFetchers;
    }

    public void setFieldDataFetchers(Map<String, String> fieldDataFetchers) {
        this.fieldDataFetchers = fieldDataFetchers;
    }

    public void addFieldDataFetcher(String forReturn, String className) {
        this.fieldDataFetchers.put(forReturn, className);
    }

    public boolean hasFieldDataFetchers() {
        return !this.fieldDataFetchers.isEmpty();
    }

    public List<Operation> getBatchOperations() {
        ArrayList<Operation> batchOperations = new ArrayList<Operation>();
        if (this.hasTypes()) {
            for (Type type : this.types.values()) {
                if (!type.hasBatchOperations()) continue;
                batchOperations.addAll(type.getBatchOperations().values());
            }
        }
        return batchOperations;
    }

    public void addCustomScalarType(CustomScalarType customScalarType) {
        this.customScalarTypes.add(customScalarType);
        Scalars.registerCustomScalarInSchema(customScalarType.getName(), customScalarType.getClassName());
    }

    public List<CustomScalarType> getCustomScalarTypes() {
        return this.customScalarTypes;
    }

    public boolean hasCustomScalarTypes() {
        return !this.customScalarTypes.isEmpty();
    }

    public List<DirectiveType> getDirectiveTypes() {
        return this.directiveTypes;
    }

    public void setDirectiveTypes(List<DirectiveType> directiveTypes) {
        this.directiveTypes = directiveTypes;
    }

    public void addDirectiveType(DirectiveType directiveType) {
        this.directiveTypes.add(directiveType);
    }

    public boolean hasDirectiveTypes() {
        return !this.directiveTypes.isEmpty();
    }

    public String toString() {
        return "Schema{description='" + this.description + "', queries=" + String.valueOf(this.queries) + ", mutations=" + String.valueOf(this.mutations) + ", subscriptions=" + String.valueOf(this.subscriptions) + ", resolvers=" + String.valueOf(this.resolvers) + ", namespacedQueries=" + String.valueOf(this.namespacedQueries) + ", namespacedMutations=" + String.valueOf(this.namespacedMutations) + ", directiveTypes=" + String.valueOf(this.directiveTypes) + ", customScalarTypes=" + String.valueOf(this.customScalarTypes) + ", inputs=" + String.valueOf(this.inputs) + ", types=" + String.valueOf(this.types) + ", interfaces=" + String.valueOf(this.interfaces) + ", unions=" + String.valueOf(this.unions) + ", enums=" + String.valueOf(this.enums) + ", errors=" + String.valueOf(this.errors) + ", directiveInstances=" + String.valueOf(this.directiveInstances) + "}";
    }

    public List<DirectiveInstance> getDirectiveInstances() {
        return this.directiveInstances;
    }

    public void setDirectiveInstances(List<DirectiveInstance> directiveInstances) {
        this.directiveInstances = directiveInstances;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addNamespacedQuery(Namespace namespace, Operation operation) {
        NamespaceContainer groupContainer = this.namespacedQueries.computeIfAbsent(namespace.getNames().get(0), key -> new NamespaceContainer());
        groupContainer.add(namespace.getNames(), namespace.getDescription(), operation);
    }

    public void addNamespacedMutation(Namespace namespace, Operation operation) {
        NamespaceContainer groupContainer = this.namespacedMutations.computeIfAbsent(namespace.getNames().get(0), key -> new NamespaceContainer());
        groupContainer.add(namespace.getNames(), namespace.getDescription(), operation);
    }

    public boolean hasNamespaceQueries() {
        return this.namespacedQueries.values().stream().anyMatch(NamespaceContainer::hasOperations);
    }

    public boolean hasNamespaceMutations() {
        return this.namespacedMutations.values().stream().anyMatch(NamespaceContainer::hasOperations);
    }
}

