/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import graphql.language.StringValue;
import io.smallrye.graphql.api.federation.Key;
import io.smallrye.graphql.api.federation.policy.Policy;
import io.smallrye.graphql.api.federation.requiresscopes.RequiresScopes;
import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.DirectiveType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class Directives {
    private final Map<DotName, DirectiveType> directiveTypes = new HashMap<DotName, DirectiveType>();
    private final List<DirectiveType> directiveTypesOther = new ArrayList<DirectiveType>();
    private static final Logger LOG = Logger.getLogger((String)Directives.class.getName());

    public Directives(List<DirectiveType> directiveTypes) {
        for (DirectiveType directiveType : directiveTypes) {
            if (directiveType.getClassName() != null) {
                this.directiveTypes.put(DotName.createSimple((String)directiveType.getClassName()), directiveType);
                continue;
            }
            this.directiveTypesOther.add(directiveType);
        }
    }

    public List<DirectiveInstance> buildDirectiveInstances(Annotations annotations, String directiveLocation, String referenceName) {
        return this.directiveTypes.keySet().stream().flatMap(annotations::resolve).map(this::toDirectiveInstance).peek(directiveInstance -> {
            if (!directiveInstance.getType().getLocations().contains(directiveLocation)) {
                throw new SchemaBuilderException(String.format("Directive instance: '%s' assigned to '%s' cannot be applied. The directive is allowed on locations '%s' but on '%s'", directiveInstance.getType().getClassName(), referenceName, directiveInstance.getType().getLocations(), directiveLocation));
            }
        }).collect(Collectors.toList());
    }

    private DirectiveInstance toDirectiveInstance(AnnotationInstance annotationInstance) {
        DirectiveInstance directiveInstance = new DirectiveInstance();
        DirectiveType directiveType = this.directiveTypes.get(annotationInstance.name());
        directiveInstance.setType(directiveType);
        for (AnnotationValue annotationValue : annotationInstance.values()) {
            String annotationValueName = this.getAnnotationValueName(directiveType, annotationValue.name());
            if (directiveType.getClassName().equals(Policy.class.getName()) || directiveType.getClassName().equals(RequiresScopes.class.getName())) {
                directiveInstance.setValue(annotationValueName, this.valueObjectNestedList(annotationValue));
                continue;
            }
            if (directiveType.getClassName().equals(Key.class.getName()) && annotationValueName.equals("fields")) {
                directiveInstance.setValue(annotationValueName, (Object)new StringValue((String)this.valueObject(annotationValue.asNested().value())));
                continue;
            }
            directiveInstance.setValue(annotationValueName, this.valueObject(annotationValue));
        }
        return directiveInstance;
    }

    private String getAnnotationValueName(DirectiveType directiveType, String annotationName) {
        ClassInfo classInfo = ScanningContext.getIndex().getClassByName(directiveType.getClassName());
        Optional<MethodInfo> matchingMethod = classInfo.methods().stream().filter(methodInfo -> methodInfo.name().equals(annotationName)).findFirst();
        if (matchingMethod.isPresent()) {
            MethodInfo method = matchingMethod.get();
            return TypeNameHelper.getMethodName(matchingMethod.get(), Annotations.getAnnotationsForInterfaceField(method));
        }
        return annotationName;
    }

    private Object valueObject(AnnotationValue value) {
        if (value.kind() == AnnotationValue.Kind.ARRAY) {
            AnnotationValue[] annotationValues = (AnnotationValue[])value.value();
            Object[] objects = new Object[annotationValues.length];
            for (int i = 0; i < annotationValues.length; ++i) {
                objects[i] = this.valueObject(annotationValues[i]);
            }
            return objects;
        }
        if (value.kind() == AnnotationValue.Kind.NESTED) {
            AnnotationInstance annotationInstance = (AnnotationInstance)value.value();
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            if (annotationInstance != null) {
                for (AnnotationValue annotationValue : annotationInstance.values()) {
                    values.put(annotationValue.name(), this.valueObject(annotationValue));
                }
            }
            return values;
        }
        return value.value();
    }

    private List<List<Object>> valueObjectNestedList(AnnotationValue value) {
        this.valueObject(value);
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        for (AnnotationValue annotationValue : value.asArrayList()) {
            ArrayList<Object> nestedValues = new ArrayList<Object>();
            for (AnnotationValue nestedAnnotationValue : ((AnnotationValue)annotationValue.asNested().values().get(0)).asArrayList()) {
                nestedValues.add(this.valueObject(nestedAnnotationValue));
            }
            values.add(nestedValues);
        }
        return values;
    }

    public Map<DotName, DirectiveType> getDirectiveTypes() {
        return this.directiveTypes;
    }
}

