/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema;

import io.smallrye.graphql.schema.ScanningContext;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Deque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class Classes {
    @Deprecated
    private static final DotName COMPLETABLE_FUTURE = DotName.createSimple((String)CompletableFuture.class.getName());
    @Deprecated
    private static final DotName COMPLETION_STAGE = DotName.createSimple((String)CompletionStage.class.getName());
    @Deprecated
    private static final DotName UNI = DotName.createSimple((String)"io.smallrye.mutiny.Uni");
    @Deprecated
    private static final DotName MULTI = DotName.createSimple((String)"io.smallrye.mutiny.Multi");
    @Deprecated
    private static final DotName PUBLISHER = DotName.createSimple((String)"org.reactivestreams.Publisher");
    public static final DotName SERIALIZABLE = DotName.createSimple((String)Serializable.class.getName());
    public static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());
    public static final DotName COLLECTION = DotName.createSimple((String)Collection.class.getName());
    public static final DotName LIST = DotName.createSimple((String)List.class.getName());
    public static final DotName LINKED_LIST = DotName.createSimple((String)LinkedList.class.getName());
    public static final DotName VECTOR = DotName.createSimple((String)Vector.class.getName());
    public static final DotName ARRAY_LIST = DotName.createSimple((String)ArrayList.class.getName());
    public static final DotName STACK = DotName.createSimple((String)Stack.class.getName());
    public static final DotName SET = DotName.createSimple((String)Set.class.getName());
    public static final DotName HASH_SET = DotName.createSimple((String)HashSet.class.getName());
    public static final DotName SORTED_SET = DotName.createSimple((String)SortedSet.class.getName());
    public static final DotName TREE_SET = DotName.createSimple((String)TreeSet.class.getName());
    public static final DotName QUEUE = DotName.createSimple((String)Queue.class.getName());
    public static final DotName DEQUE = DotName.createSimple((String)Deque.class.getName());
    public static final DotName MAP = DotName.createSimple((String)Map.class.getName());
    public static final DotName HASH_MAP = DotName.createSimple((String)HashMap.class.getName());
    public static final DotName TREE_MAP = DotName.createSimple((String)TreeMap.class.getName());
    public static final DotName HASHTABLE = DotName.createSimple((String)Hashtable.class.getName());
    public static final DotName SORTED_MAP = DotName.createSimple((String)SortedMap.class.getName());
    public static final DotName ENTRY = DotName.createSimple((String)"io.smallrye.graphql.api.Entry");
    public static final DotName OPTIONAL = DotName.createSimple((String)Optional.class.getName());
    public static final DotName ENUM = DotName.createSimple((String)Enum.class.getName());
    public static final DotName RECORD = DotName.createSimple((String)"java.lang.Record");
    public static final DotName LOCALDATE = DotName.createSimple((String)LocalDate.class.getName());
    public static final DotName LOCALDATETIME = DotName.createSimple((String)LocalDateTime.class.getName());
    public static final DotName LOCALTIME = DotName.createSimple((String)LocalTime.class.getName());
    public static final DotName ZONEDDATETIME = DotName.createSimple((String)ZonedDateTime.class.getName());
    public static final DotName OFFSETDATETIME = DotName.createSimple((String)OffsetDateTime.class.getName());
    public static final DotName OFFSETTIME = DotName.createSimple((String)OffsetTime.class.getName());
    public static final DotName INSTANT = DotName.createSimple((String)Instant.class.getName());
    public static final DotName CALENDAR = DotName.createSimple((String)Calendar.class.getName());
    public static final DotName GREGORIAN_CALENDAR = DotName.createSimple((String)GregorianCalendar.class.getName());
    public static final DotName PERIOD = DotName.createSimple((String)Period.class.getName());
    public static final DotName DURATION = DotName.createSimple((String)Duration.class.getName());
    public static final DotName UTIL_DATE = DotName.createSimple((String)java.util.Date.class.getName());
    public static final DotName SQL_DATE = DotName.createSimple((String)Date.class.getName());
    public static final DotName SQL_TIMESTAMP = DotName.createSimple((String)Timestamp.class.getName());
    public static final DotName SQL_TIME = DotName.createSimple((String)Time.class.getName());
    private static final DotName BYTE = DotName.createSimple((String)Byte.class.getName());
    private static final DotName BYTE_PRIMATIVE = DotName.createSimple((String)Byte.TYPE.getName());
    private static final DotName SHORT = DotName.createSimple((String)Short.class.getName());
    private static final DotName SHORT_PRIMATIVE = DotName.createSimple((String)Short.TYPE.getName());
    private static final DotName INTEGER = DotName.createSimple((String)Integer.class.getName());
    private static final DotName INTEGER_PRIMATIVE = DotName.createSimple((String)Integer.TYPE.getName());
    private static final DotName INTEGER_OPTIONAL = DotName.createSimple((String)OptionalInt.class.getName());
    private static final DotName INTEGER_ATOMIC = DotName.createSimple((String)AtomicInteger.class.getName());
    private static final DotName BIG_INTEGER = DotName.createSimple((String)BigInteger.class.getName());
    private static final DotName DOUBLE = DotName.createSimple((String)Double.class.getName());
    private static final DotName DOUBLE_PRIMATIVE = DotName.createSimple((String)Double.TYPE.getName());
    private static final DotName DOUBLE_OPTIONAL = DotName.createSimple((String)OptionalDouble.class.getName());
    private static final DotName BIG_DECIMAL = DotName.createSimple((String)BigDecimal.class.getName());
    private static final DotName LONG = DotName.createSimple((String)Long.class.getName());
    private static final DotName LONG_PRIMATIVE = DotName.createSimple((String)Long.TYPE.getName());
    private static final DotName LONG_OPTIONAL = DotName.createSimple((String)OptionalLong.class.getName());
    private static final DotName LONG_ATOMIC = DotName.createSimple((String)AtomicLong.class.getName());
    private static final DotName FLOAT = DotName.createSimple((String)Float.class.getName());
    private static final DotName FLOAT_PRIMATIVE = DotName.createSimple((String)Float.TYPE.getName());
    public static final DotName JAVAX_JSONB_ADAPTER = DotName.createSimple((String)"javax.json.bind.adapter.JsonbAdapter");
    public static final DotName JAKARTA_JSONB_ADAPTER = DotName.createSimple((String)"jakarta.json.bind.adapter.JsonbAdapter");
    public static final DotName ADAPTER = DotName.createSimple((String)"io.smallrye.graphql.api.Adapter");
    public static final DotName JAVAX_VALIDATION_ANNOTATION_EMAIL = DotName.createSimple((String)"javax.validation.constraints.Email");
    public static final DotName JAVAX_VALIDATION_ANNOTATION_MAX = DotName.createSimple((String)"javax.validation.constraints.Max");
    public static final DotName JAVAX_VALIDATION_ANNOTATION_DECIMAL_MAX = DotName.createSimple((String)"javax.validation.constraints.DecimalMax");
    public static final DotName JAVAX_VALIDATION_ANNOTATION_MIN = DotName.createSimple((String)"javax.validation.constraints.Min");
    public static final DotName JAVAX_VALIDATION_ANNOTATION_DECIMAL_MIN = DotName.createSimple((String)"javax.validation.constraints.DecimalMin");
    public static final DotName JAVAX_VALIDATION_ANNOTATION_PATTERN = DotName.createSimple((String)"javax.validation.constraints.Pattern");
    public static final DotName JAVAX_VALIDATION_ANNOTATION_SIZE = DotName.createSimple((String)"javax.validation.constraints.Size");
    public static final DotName JAKARTA_VALIDATION_ANNOTATION_EMAIL = DotName.createSimple((String)"jakarta.validation.constraints.Email");
    public static final DotName JAKARTA_VALIDATION_ANNOTATION_MAX = DotName.createSimple((String)"jakarta.validation.constraints.Max");
    public static final DotName JAKARTA_VALIDATION_ANNOTATION_DECIMAL_MAX = DotName.createSimple((String)"jakarta.validation.constraints.DecimalMax");
    public static final DotName JAKARTA_VALIDATION_ANNOTATION_MIN = DotName.createSimple((String)"jakarta.validation.constraints.Min");
    public static final DotName JAKARTA_VALIDATION_ANNOTATION_DECIMAL_MIN = DotName.createSimple((String)"jakarta.validation.constraints.DecimalMin");
    public static final DotName JAKARTA_VALIDATION_ANNOTATION_PATTERN = DotName.createSimple((String)"jakarta.validation.constraints.Pattern");
    public static final DotName JAKARTA_VALIDATION_ANNOTATION_SIZE = DotName.createSimple((String)"jakarta.validation.constraints.Size");
    private static final List<DotName> KNOWN_COLLECTIONS = new ArrayList<DotName>();
    private static final List<DotName> KNOWN_MAPS = new ArrayList<DotName>();

    private Classes() {
    }

    public static boolean isWrapper(Type type) {
        return Classes.isParameterized(type) || Classes.isArray(type);
    }

    public static boolean isParameterized(Type type) {
        return type.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE);
    }

    public static boolean isOptional(Type type) {
        return Classes.isParameterized(type) && type.name().equals((Object)OPTIONAL) || type.name().equals((Object)LONG_OPTIONAL) || type.name().equals((Object)DOUBLE_OPTIONAL) || type.name().equals((Object)INTEGER_OPTIONAL);
    }

    public static boolean isInterface(ClassInfo classInfo) {
        if (classInfo == null) {
            return false;
        }
        return Modifier.isInterface(classInfo.flags());
    }

    public static boolean isEnum(ClassInfo classInfo) {
        if (classInfo == null) {
            return false;
        }
        return ENUM.equals((Object)classInfo.superName());
    }

    public static boolean isNumberLikeTypeOrContainedIn(Type type) {
        return Classes.isTypeOrContainedIn(type, BYTE, BYTE_PRIMATIVE, SHORT, SHORT_PRIMATIVE, INTEGER, INTEGER_PRIMATIVE, BIG_INTEGER, DOUBLE, DOUBLE_PRIMATIVE, BIG_DECIMAL, LONG, LONG_PRIMATIVE, FLOAT, FLOAT_PRIMATIVE, INTEGER_OPTIONAL, DOUBLE_OPTIONAL, LONG_OPTIONAL, INTEGER_ATOMIC, LONG_ATOMIC);
    }

    public static boolean isDateLikeTypeOrContainedIn(Type type) {
        return Classes.isTypeOrContainedIn(type, LOCALDATE, LOCALTIME, LOCALDATETIME, ZONEDDATETIME, OFFSETDATETIME, OFFSETTIME, UTIL_DATE, SQL_DATE, SQL_TIMESTAMP, SQL_TIME, INSTANT, CALENDAR, GREGORIAN_CALENDAR);
    }

    private static boolean isTypeOrContainedIn(Type type, DotName ... valid) {
        switch (type.kind()) {
            case PARAMETERIZED_TYPE: {
                Type typeInCollection = (Type)type.asParameterizedType().arguments().get(0);
                return Classes.isTypeOrContainedIn(typeInCollection, valid);
            }
            case ARRAY: {
                Type typeInArray = type.asArrayType().component();
                return Classes.isTypeOrContainedIn(typeInArray, valid);
            }
        }
        for (DotName dotName : valid) {
            if (!type.name().toString().equals(dotName.toString())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    private static boolean isAsyncType(Type type) {
        return type.name().equals((Object)COMPLETABLE_FUTURE) || type.name().equals((Object)COMPLETION_STAGE) || type.name().equals((Object)UNI) || type.name().equals((Object)MULTI) || type.name().equals((Object)PUBLISHER);
    }

    @Deprecated
    public static boolean isCollectionOrArray(Type type) {
        return type.kind().equals((Object)Type.Kind.ARRAY) || Classes.isCollection(type);
    }

    public static boolean isArray(Type type) {
        return type.kind().equals((Object)Type.Kind.ARRAY);
    }

    public static boolean isCollection(Type type) {
        if (Classes.isParameterized(type)) {
            ClassInfo clazz = ScanningContext.getIndex().getClassByName(type.name());
            if (clazz == null) {
                try {
                    Class<?> clazzLoaded = Classes.class.getClassLoader().loadClass(type.name().toString());
                    return Collection.class.isAssignableFrom(clazzLoaded);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Info not found in Jandex index nor classpath for class name:" + String.valueOf(type.name()));
                }
            }
            if (KNOWN_COLLECTIONS.contains(clazz.name())) {
                return true;
            }
            for (Type intf : clazz.interfaceTypes()) {
                if (!Classes.isCollection(intf)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMap(Type type) {
        if (Classes.isParameterized(type)) {
            ClassInfo clazz = ScanningContext.getIndex().getClassByName(type.name());
            if (clazz == null) {
                try {
                    Class<?> clazzLoaded = Classes.class.getClassLoader().loadClass(type.name().toString());
                    return Map.class.isAssignableFrom(clazzLoaded);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Info not found in Jandex index nor classpath for class name:" + String.valueOf(type.name()));
                }
            }
            if (KNOWN_MAPS.contains(clazz.name())) {
                return true;
            }
            for (Type intf : clazz.interfaceTypes()) {
                if (!Classes.isMap(intf)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isUnwrappedType(Type type) {
        return Classes.isParameterized(type) && (Classes.isOptional(type) || Classes.isAsyncType(type));
    }

    static {
        KNOWN_COLLECTIONS.add(COLLECTION);
        KNOWN_COLLECTIONS.add(LIST);
        KNOWN_COLLECTIONS.add(LINKED_LIST);
        KNOWN_COLLECTIONS.add(VECTOR);
        KNOWN_COLLECTIONS.add(ARRAY_LIST);
        KNOWN_COLLECTIONS.add(STACK);
        KNOWN_COLLECTIONS.add(SET);
        KNOWN_COLLECTIONS.add(HASH_SET);
        KNOWN_COLLECTIONS.add(SORTED_SET);
        KNOWN_COLLECTIONS.add(TREE_SET);
        KNOWN_COLLECTIONS.add(QUEUE);
        KNOWN_COLLECTIONS.add(DEQUE);
        KNOWN_MAPS.add(MAP);
        KNOWN_MAPS.add(HASH_MAP);
        KNOWN_MAPS.add(TREE_MAP);
        KNOWN_MAPS.add(HASHTABLE);
        KNOWN_MAPS.add(SORTED_MAP);
    }
}

