/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.core;

import io.smallrye.graphql.client.core.Buildable;
import io.smallrye.graphql.client.core.FieldOrFragment;
import io.smallrye.graphql.client.impl.core.AbstractField;
import io.smallrye.graphql.client.impl.core.ArgumentImpl;
import java.util.stream.Collectors;

public class FieldImpl
extends AbstractField {
    public String build() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        if (!this.getArguments().isEmpty()) {
            builder.append("(");
            builder.append(this._buildArgs());
            builder.append(")");
        }
        if (!this.getDirectives().isEmpty()) {
            builder.append(this._buildDirectives());
        }
        if (!this.getFields().isEmpty()) {
            builder.append("{");
            builder.append(this._buildFields());
            builder.append("}");
        }
        return builder.toString();
    }

    private String _buildArgs() {
        StringBuilder builder = new StringBuilder();
        ArgumentImpl[] arguments = this.getArguments().toArray(new ArgumentImpl[0]);
        for (int i = 0; i < arguments.length; ++i) {
            ArgumentImpl argument = arguments[i];
            builder.append(argument.build());
            if (i >= arguments.length - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private String _buildFields() {
        StringBuilder builder = new StringBuilder();
        FieldOrFragment[] fields = this.getFields().toArray(new FieldOrFragment[0]);
        for (int i = 0; i < fields.length; ++i) {
            FieldOrFragment field = fields[i];
            builder.append(field.build());
            if (i >= fields.length - 1) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    private String _buildDirectives() {
        return this.getDirectives().stream().map(Buildable::build).collect(Collectors.joining());
    }
}

