/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl;

import io.smallrye.graphql.client.InvalidResponseException;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientMessages;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;

public class SmallRyeGraphQLClientMessages_$bundle
implements SmallRyeGraphQLClientMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final SmallRyeGraphQLClientMessages_$bundle INSTANCE = new SmallRyeGraphQLClientMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected SmallRyeGraphQLClientMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String cannotParseResponse$str() {
        return "SRGQLDC035000: Cannot parse response: %s";
    }

    @Override
    public final RuntimeException cannotParseResponse(String response, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotParseResponse$str(), response), cause);
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String urlNotConfiguredForNamedClient$str() {
        return "SRGQLDC035001: URL not configured for client. Please define the property %s/mp-graphql/url or pass it to your client builder dynamically";
    }

    @Override
    public final NoSuchElementException urlNotConfiguredForNamedClient(String name) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.urlNotConfiguredForNamedClient$str(), name));
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String urlNotConfiguredForProgrammaticClient$str() {
        return "SRGQLDC035002: URL not configured for client. Please pass a url using your client builder.";
    }

    @Override
    public final NoSuchElementException urlNotConfiguredForProgrammaticClient() {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.urlNotConfiguredForProgrammaticClient$str(), new Object[0]));
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDataInResponse$str() {
        return "SRGQLDC035003: Response did not contain any data";
    }

    @Override
    public final NoSuchElementException noDataInResponse() {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.noDataInResponse$str(), new Object[0]));
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fieldNotFoundInResponse$str() {
        return "SRGQLDC035004: Field %s not found in response's data. Available fields are: %s";
    }

    @Override
    public final NoSuchElementException fieldNotFoundInResponse(String field, Set<String> availableFields) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.fieldNotFoundInResponse$str(), field, availableFields));
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedValueInResponse$str() {
        return "SRGQLDC035005: Value in the response at path '%s' is of an unexpected type: %s";
    }

    @Override
    public final RuntimeException unexpectedValueInResponse(String path, String value) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unexpectedValueInResponse$str(), path, value));
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String responseContainsSingleObject$str() {
        return "SRGQLDC035006: Field %s in the response is a single object, please use the method `getObject` instead of `getList`";
    }

    @Override
    public final IllegalArgumentException responseContainsSingleObject(String field) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.responseContainsSingleObject$str(), field));
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String responseContainsArray$str() {
        return "SRGQLDC035007: Field %s in the response is an array, please use the method `getList` instead of `getObject`";
    }

    @Override
    public final IllegalArgumentException responseContainsArray(String field) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.responseContainsArray$str(), field));
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fieldRecursionFound$str() {
        return "SRGQLDC035008: Field recursion found";
    }

    @Override
    public final IllegalStateException fieldRecursionFound() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.fieldRecursionFound$str(), new Object[0]));
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInstantiateDomainObject$str() {
        return "SRGQLDC035010: Cannot instantiate %s";
    }

    @Override
    public final RuntimeException cannotInstantiateDomainObject(String object, Throwable t) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotInstantiateDomainObject$str(), object), t);
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingDataForOperation$str() {
        return "SRGQLDC035011: The response does not contain any data for operation %s";
    }

    @Override
    public final RuntimeException missingDataForOperation(String operation) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.missingDataForOperation$str(), operation));
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullResponseBody$str() {
        return "SRGQLDC035012: Response body was null";
    }

    @Override
    public final InvalidResponseException nullResponseBody() {
        InvalidResponseException result = new InvalidResponseException(String.format(this.getLoggingLocale(), this.nullResponseBody$str(), new Object[0]));
        SmallRyeGraphQLClientMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

