/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl;

import io.smallrye.graphql.client.GraphQLError;
import io.smallrye.graphql.client.InvalidResponseException;
import io.smallrye.graphql.client.impl.GraphQLErrorImpl;
import io.smallrye.graphql.client.impl.ResponseImpl;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientLogging;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public class ResponseReader {
    private static final Logger LOG = Logger.getLogger((String)ResponseReader.class.getName());
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);

    public static JsonObject parseGraphQLResponse(String input) {
        return ResponseReader.parseGraphQLResponse(input, false);
    }

    public static JsonObject parseGraphQLResponse(String input, Boolean allowUnexpectedResponseFields) {
        if (input == null) {
            return null;
        }
        JsonReader jsonReader = jsonReaderFactory.createReader((Reader)new StringReader(input));
        try {
            JsonObject jsonResponse;
            try {
                jsonResponse = jsonReader.readObject();
            }
            catch (Exception e) {
                JsonObject jsonObject = null;
                if (jsonReader != null) {
                    jsonReader.close();
                }
                return jsonObject;
            }
            if (jsonResponse.size() >= 1) {
                JsonObject jsonObject = ResponseReader.checkExpectedResponseFields(jsonResponse, allowUnexpectedResponseFields);
                return jsonObject;
            }
            JsonObject jsonObject = null;
            return jsonObject;
        }
        finally {
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private static JsonObject checkExpectedResponseFields(JsonObject jsonResponse, Boolean allowUnexpectedResponseFields) {
        for (String key : jsonResponse.keySet()) {
            if (key.equalsIgnoreCase("data") || key.equalsIgnoreCase("errors") || key.equalsIgnoreCase("extensions")) continue;
            if (!allowUnexpectedResponseFields.booleanValue()) {
                return null;
            }
            LOG.info((Object)("Ignored field: '" + key + "' in the response."));
        }
        return jsonResponse;
    }

    public static ResponseImpl readFrom(String input, Map<String, List<String>> headers, Integer statusCode, String statusMessage, Boolean allowUnexpectedResponseFields) {
        boolean containsKeyExtension;
        JsonObject jsonResponse = ResponseReader.parseGraphQLResponse(input, allowUnexpectedResponseFields);
        if (jsonResponse == null) {
            throw new InvalidResponseException("Unexpected response. Code=" + statusCode + ", message=\"" + statusMessage + "\", body=\"" + input + "\"");
        }
        JsonObject data = null;
        if (jsonResponse.containsKey((Object)"data")) {
            if (!jsonResponse.isNull("data")) {
                data = jsonResponse.getJsonObject("data");
            } else {
                SmallRyeGraphQLClientLogging.log.noDataInResponse();
            }
        }
        ArrayList<GraphQLError> errors = null;
        if (jsonResponse.containsKey((Object)"errors")) {
            errors = new ArrayList<GraphQLError>();
            for (JsonValue error : jsonResponse.getJsonArray("errors")) {
                errors.add(ResponseReader.readError(error));
            }
        }
        if ((containsKeyExtension = jsonResponse.containsKey((Object)"extensions")) && !jsonResponse.isNull("extensions") && !((JsonValue)jsonResponse.get((Object)"extensions")).getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
            LOG.warn((Object)("Unexpected value of 'extensions' in response: " + jsonResponse.get((Object)"extensions")));
        }
        JsonObject extensions = null;
        if (containsKeyExtension && ((JsonValue)jsonResponse.get((Object)"extensions")).getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
            extensions = jsonResponse.getJsonObject("extensions");
        }
        return new ResponseImpl(data, errors, extensions, headers, statusCode, statusMessage);
    }

    public static ResponseImpl readFrom(String input, Map<String, List<String>> headers) {
        return ResponseReader.readFrom(input, headers, null, null);
    }

    public static ResponseImpl readFrom(String input, Map<String, List<String>> headers, Integer statusCode, String statusMessage) {
        return ResponseReader.readFrom(input, headers, statusCode, statusMessage, false);
    }

    public static GraphQLError readError(JsonValue errorJson) {
        JsonObject errorObject = errorJson.asJsonObject();
        GraphQLErrorImpl decodedError = new GraphQLErrorImpl();
        try {
            JsonValue message = (JsonValue)errorObject.get((Object)"message");
            if (message instanceof JsonString) {
                decodedError.setMessage(errorObject.getString("message"));
            }
        }
        catch (RuntimeException e) {
            LOG.warn((Object)e);
        }
        try {
            if (errorObject.containsKey((Object)"locations") && ((JsonValue)errorObject.get((Object)"locations")).getValueType().equals((Object)JsonValue.ValueType.ARRAY)) {
                JsonArray locations = errorObject.getJsonArray("locations");
                ArrayList<Map<String, Integer>> locationList = new ArrayList<Map<String, Integer>>();
                for (JsonValue jsonValue : locations) {
                    JsonObject location = jsonValue.asJsonObject();
                    HashMap map = new HashMap();
                    location.forEach((key, value) -> {
                        if (value instanceof JsonNumber) {
                            map.put(key, ((JsonNumber)value).intValue());
                        }
                    });
                    locationList.add(map);
                }
                decodedError.setLocations(locationList);
            }
        }
        catch (RuntimeException e) {
            LOG.warn((Object)e);
        }
        try {
            if (errorObject.containsKey((Object)"path") && ((JsonValue)errorObject.get((Object)"path")).getValueType().equals((Object)JsonValue.ValueType.ARRAY)) {
                Object[] path = new Object[errorObject.getJsonArray("path").size()];
                int i = 0;
                for (JsonValue segment : errorObject.getJsonArray("path")) {
                    switch (segment.getValueType()) {
                        case STRING: {
                            path[i] = ((JsonString)segment).getString();
                            break;
                        }
                        case NUMBER: {
                            path[i] = ((JsonNumber)segment).intValue();
                            break;
                        }
                        default: {
                            SmallRyeGraphQLClientLogging.log.unknownPathSegmentType(segment.getValueType());
                        }
                    }
                    ++i;
                }
                decodedError.setPath(path);
            }
        }
        catch (RuntimeException e) {
            LOG.warn((Object)e);
        }
        try {
            if (errorObject.containsKey((Object)"extensions") && ((JsonValue)errorObject.get((Object)"extensions")).getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
                JsonObject extensions = errorObject.getJsonObject("extensions");
                HashMap<String, Object> extensionMap = new HashMap<String, Object>();
                extensions.forEach((key, value) -> extensionMap.put((String)key, ResponseReader.decode(value)));
                decodedError.setExtensions(extensionMap);
            } else {
                decodedError.setExtensions(Collections.emptyMap());
            }
        }
        catch (RuntimeException e) {
            LOG.warn((Object)e);
        }
        try {
            HashMap<String, Object> otherFields = new HashMap<String, Object>();
            for (String key2 : errorObject.keySet()) {
                if (key2.equals("extensions") || key2.equals("locations") || key2.equals("message") || key2.equals("path")) continue;
                otherFields.put(key2, ResponseReader.decode((JsonValue)errorObject.get((Object)key2)));
            }
            if (!otherFields.isEmpty()) {
                decodedError.setOtherFields(otherFields);
            }
        }
        catch (RuntimeException e) {
            LOG.warn((Object)e);
        }
        return decodedError;
    }

    private static Object decode(JsonValue value) {
        switch (value.getValueType()) {
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                return ((JsonNumber)value).longValue();
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case NULL: {
                return null;
            }
        }
        return value;
    }
}

