/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.json;

import io.smallrye.graphql.client.GraphQLClientException;
import io.smallrye.graphql.client.GraphQLError;
import io.smallrye.graphql.client.InvalidResponseException;
import io.smallrye.graphql.client.impl.ResponseReader;
import io.smallrye.graphql.client.impl.typesafe.json.JsonArrayReader;
import io.smallrye.graphql.client.impl.typesafe.json.JsonBooleanReader;
import io.smallrye.graphql.client.impl.typesafe.json.JsonMapReader;
import io.smallrye.graphql.client.impl.typesafe.json.JsonNullReader;
import io.smallrye.graphql.client.impl.typesafe.json.JsonNumberReader;
import io.smallrye.graphql.client.impl.typesafe.json.JsonObjectReader;
import io.smallrye.graphql.client.impl.typesafe.json.JsonStringReader;
import io.smallrye.graphql.client.impl.typesafe.json.JsonUtils;
import io.smallrye.graphql.client.impl.typesafe.json.Location;
import io.smallrye.graphql.client.impl.typesafe.json.Reader;
import io.smallrye.graphql.client.impl.typesafe.reflection.FieldInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import io.smallrye.graphql.client.typesafe.api.ErrorOr;
import io.smallrye.graphql.client.typesafe.api.TypesafeResponse;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public class JsonReader
extends Reader<JsonValue> {
    public static Object readJson(String description, TypeInfo type, JsonValue value, FieldInfo field) {
        return JsonReader.readJson(new Location(type, description), type, value, field);
    }

    public static Object readJsonTypesafeResponse(String description, TypeInfo type, JsonValue value, FieldInfo field) {
        return JsonReader.readJsonTypesafeResponse(new Location(type, description), type, value, field);
    }

    static Object readJson(Location location, TypeInfo type, JsonValue value, FieldInfo field) {
        return new JsonReader(type, location, value, field).read();
    }

    static Object readJsonTypesafeResponse(Location location, TypeInfo type, JsonValue value, FieldInfo field) {
        return new JsonReader(type, location, value, field).typesafeResponseRead();
    }

    private JsonReader(TypeInfo type, Location location, JsonValue value, FieldInfo field) {
        super(type, location, value, field);
    }

    @Override
    Object read() {
        if (this.type.isOptional()) {
            return Optional.ofNullable(JsonReader.readJson(this.location, this.type.getItemType(), this.value, this.field));
        }
        if (this.type.isAsync()) {
            return JsonReader.readJson(this.location, this.type.getItemType(), this.value, this.field);
        }
        if (this.type.isErrorOr()) {
            return this.readErrorOr();
        }
        if (this.type.isTypesafeResponse()) {
            throw new IllegalArgumentException("TypesafeResponse type should be only on the highest level of recursion");
        }
        if (this.isListOfErrors(this.value) && !this.isGraphQlErrorsType()) {
            throw this.cantApplyErrors(this.readGraphQlClientErrors());
        }
        Reader<?> reader = this.reader(this.location);
        Object result = reader.read();
        if (this.type.isOptionalNumber() && result == null) {
            return this.optionalNumberEmpty();
        }
        return result;
    }

    Object typesafeResponseRead() {
        if (!this.type.isTypesafeResponse()) {
            throw new IllegalArgumentException("Type should be TypesafeResponse");
        }
        return this.readTypesafeResponse();
    }

    private TypesafeResponse<Object> readTypesafeResponse() {
        if (this.isListOfErrors(this.value)) {
            return TypesafeResponse.ofErrors(this.readGraphQlClientErrors());
        }
        return TypesafeResponse.of((Object)JsonReader.readJson(this.location, this.type.getItemType(), this.value, this.field));
    }

    private ErrorOr<Object> readErrorOr() {
        if (this.isListOfErrors(this.value)) {
            return ErrorOr.ofErrors(this.readGraphQlClientErrors());
        }
        return ErrorOr.of((Object)JsonReader.readJson(this.location, this.type.getItemType(), this.value, this.field));
    }

    private List<GraphQLError> readGraphQlClientErrors() {
        return this.value.asJsonArray().stream().map(ResponseReader::readError).collect(Collectors.toList());
    }

    private boolean isListOfErrors(JsonValue jsonValue) {
        return JsonUtils.isListOf(jsonValue, ErrorOr.class.getSimpleName());
    }

    private boolean isGraphQlErrorsType() {
        return GraphQLError.class.isAssignableFrom(this.type.getRawType());
    }

    private GraphQLClientException cantApplyErrors(List<GraphQLError> errors) {
        return new GraphQLClientException("errors from service (and we can't apply them to a " + String.valueOf(this.location) + "; see ErrorOr)", errors);
    }

    private Reader<?> reader(Location location) {
        switch (this.value.getValueType()) {
            case ARRAY: {
                if (this.type.isCollection()) {
                    return new JsonArrayReader(this.type, location, (JsonArray)this.value, this.field);
                }
                if (this.type.isMap()) {
                    return new JsonMapReader(this.type, location, (JsonArray)this.value, this.field);
                }
                throw new InvalidResponseException("invalid " + this.type.getTypeName() + " value for " + location.getDescription() + ": " + String.valueOf(this.value));
            }
            case OBJECT: {
                return new JsonObjectReader(this.type, location, (JsonObject)this.value, this.field);
            }
            case STRING: {
                return new JsonStringReader(this.type, location, (JsonString)this.value, this.field);
            }
            case NUMBER: {
                return new JsonNumberReader(this.type, location, (JsonNumber)this.value, this.field);
            }
            case TRUE: 
            case FALSE: {
                return new JsonBooleanReader(this.type, location, this.value, this.field);
            }
            case NULL: {
                return new JsonNullReader(this.type, location, this.value, this.field);
            }
        }
        throw new InvalidResponseException("unexpected value type for " + location.getDescription() + ": " + String.valueOf(this.value));
    }

    private Object optionalNumberEmpty() {
        Object result = null;
        if (this.type.getTypeName().equals("java.util.OptionalInt")) {
            result = OptionalInt.empty();
        } else if (this.type.getTypeName().equals("java.util.OptionalLong")) {
            result = OptionalLong.empty();
        } else if (this.type.getTypeName().equals("java.util.OptionalDouble")) {
            result = OptionalDouble.empty();
        }
        return result;
    }
}

