/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.reflection;

import io.smallrye.graphql.api.Union;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientMessages;
import io.smallrye.graphql.client.impl.typesafe.reflection.ConstructionInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.FieldInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.api.ErrorOr;
import io.smallrye.graphql.client.typesafe.api.TypesafeResponse;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.json.bind.annotation.JsonbSubtype;
import jakarta.json.bind.annotation.JsonbTransient;
import jakarta.json.bind.annotation.JsonbTypeInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.microprofile.graphql.Ignore;
import org.eclipse.microprofile.graphql.NonNull;

public class TypeInfo {
    private static final Class<? extends Annotation> JACKSON_JSON_IGNORE = TypeInfo.findAnnotation("com.fasterxml.jackson.annotation.JsonIgnore");
    private static final Class<? extends Annotation> JAKARTA_NOT_NULL = TypeInfo.findAnnotation("jakarta.validation.constraints.NotNull");
    private final TypeInfo container;
    private final Type type;
    private final AnnotatedType annotatedType;
    private final Type genericType;
    private TypeInfo itemType;
    private TypeInfo keyType;
    private TypeInfo valueType;
    private Class<?> rawType;

    private static Class<? extends Annotation> findAnnotation(String className) {
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static TypeInfo of(Type type) {
        return new TypeInfo(null, type);
    }

    TypeInfo(TypeInfo container, Type type) {
        this(container, type, null, null);
    }

    TypeInfo(TypeInfo container, Type type, AnnotatedType annotatedType) {
        this(container, type, annotatedType, null);
    }

    TypeInfo(TypeInfo container, Type type, AnnotatedType annotatedType, Type genericType) {
        this.container = container;
        this.type = Objects.requireNonNull(type);
        this.annotatedType = annotatedType;
        this.genericType = genericType;
    }

    public String toString() {
        return String.valueOf(this.annotatedType == null ? (this.type instanceof Class ? ((Class)this.type).getName() : this.type) : this.annotatedType) + (String)(this.container == null ? "" : " in " + String.valueOf(this.container));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeInfo that = (TypeInfo)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String getTypeName() {
        if (this.type instanceof TypeVariable) {
            return this.resolveTypeVariable().getTypeName();
        }
        return this.type.getTypeName();
    }

    public String getGraphQlTypeName() {
        if (this.isAnnotated(org.eclipse.microprofile.graphql.Type.class)) {
            return this.getAnnotation(org.eclipse.microprofile.graphql.Type.class).value();
        }
        return this.getSimpleName();
    }

    public String getSimpleName() {
        if (this.type instanceof Class) {
            return ((Class)this.type).getSimpleName();
        }
        return this.getTypeName();
    }

    private Class<?> resolveTypeVariable() {
        ParameterizedType parameterizedType = (ParameterizedType)this.container.type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Type actualTypeArgument = actualTypeArguments[0];
        if (actualTypeArgument instanceof Class) {
            return (Class)actualTypeArgument;
        }
        if (actualTypeArgument instanceof ParameterizedType) {
            return Object.class;
        }
        throw new UnsupportedOperationException("can't resolve type variable of a " + actualTypeArgument.getTypeName());
    }

    public String getPackage() {
        return ((Class)this.type).getPackage().getName();
    }

    public boolean isCollection() {
        return this.ifClass(Class::isArray) || Collection.class.isAssignableFrom(this.getRawType());
    }

    public boolean isAsync() {
        return this.isMulti() || this.isUni();
    }

    public boolean isMulti() {
        return Multi.class.isAssignableFrom(this.getRawType());
    }

    public boolean isUni() {
        return Uni.class.isAssignableFrom(this.getRawType());
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getRawType());
    }

    public boolean isOptionalNumber() {
        Class<?> rawType = this.getRawType();
        return OptionalInt.class.isAssignableFrom(rawType) || OptionalLong.class.isAssignableFrom(rawType) || OptionalDouble.class.isAssignableFrom(rawType);
    }

    private boolean ifClass(Predicate<Class<?>> predicate) {
        return this.type instanceof Class && predicate.test((Class)this.type);
    }

    public Stream<FieldInfo> fields() {
        return this.fields(this.getRawType());
    }

    private Stream<FieldInfo> fields(Class<?> rawType) {
        return rawType == null ? Stream.of(new FieldInfo[0]) : Stream.concat(this.fields(rawType.getSuperclass()), Stream.of(this.getDeclaredFields(rawType)).filter(this::isGraphQlField).map(field -> new FieldInfo(this, (Field)field)));
    }

    private Field[] getDeclaredFields(Class<?> type) {
        if (System.getSecurityManager() == null) {
            return type.getDeclaredFields();
        }
        return AccessController.doPrivileged(type::getDeclaredFields);
    }

    private boolean isGraphQlField(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !TypeInfo.isSynthetic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers()) && !this.isAnnotatedBy(field, Ignore.class, JsonbTransient.class, JACKSON_JSON_IGNORE);
    }

    @SafeVarargs
    private boolean isAnnotatedBy(Field field, Class<? extends Annotation> ... annotationClasses) {
        return Stream.of(annotationClasses).filter(Objects::nonNull).anyMatch(field::isAnnotationPresent);
    }

    private static boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    public boolean isOptional() {
        return Optional.class.equals(this.getRawType());
    }

    public boolean isErrorOr() {
        return ErrorOr.class.equals(this.getRawType());
    }

    public boolean isTypesafeResponse() {
        return TypesafeResponse.class.equals(this.getRawType());
    }

    public boolean isRecord() {
        Class<?> superclass = this.rawType.getSuperclass();
        return superclass != null && superclass.getName().equals("java.lang.Record");
    }

    public boolean isUnion() {
        return this.isAnnotated(Union.class);
    }

    public boolean isInterface() {
        return this.getRawType().isInterface() && !this.isUnion();
    }

    public boolean isScalar() {
        return this.isPrimitive() || Void.class.isAssignableFrom(this.getRawType()) || Number.class.isAssignableFrom(this.getRawType()) || Boolean.class.isAssignableFrom(this.getRawType()) || this.isEnum() || CharSequence.class.isAssignableFrom(this.getRawType()) || Character.class.equals(this.getRawType()) || Date.class.equals(this.getRawType()) || Calendar.class.isAssignableFrom(this.getRawType()) || UUID.class.equals(this.getRawType()) || this.scalarConstructor().isPresent() || OptionalInt.class.equals(this.getRawType()) || OptionalLong.class.equals(this.getRawType()) || OptionalDouble.class.equals(this.getRawType());
    }

    public boolean isPrimitive() {
        return this.getRawType().isPrimitive();
    }

    public boolean isVoid() {
        return Void.TYPE.isAssignableFrom(this.getRawType()) || Void.class.isAssignableFrom(this.getRawType());
    }

    public boolean isEnum() {
        if (this.type instanceof TypeVariable) {
            Class<?> resolved = this.resolveTypeVariable();
            return resolved.isEnum();
        }
        return this.ifClass(Class::isEnum);
    }

    public Optional<ConstructionInfo> scalarConstructor() {
        return Stream.of(this.getRawType().getMethods()).filter(this::isStaticStringConstructor).findFirst().map(ConstructionInfo::new);
    }

    private boolean isStaticStringConstructor(Method method) {
        return this.isStaticConstructorMethodNamed(method, "of") || this.isStaticConstructorMethodNamed(method, "valueOf") || this.isStaticConstructorMethodNamed(method, "parse");
    }

    private boolean isStaticConstructorMethodNamed(Method method, String name) {
        return method.getName().equals(name) && Modifier.isStatic(method.getModifiers()) && method.getReturnType().equals(this.type) && this.hasOneStringParameter(method);
    }

    private boolean hasOneStringParameter(Executable executable) {
        return executable.getParameterCount() == 1 && CharSequence.class.isAssignableFrom(executable.getParameterTypes()[0]);
    }

    public Object newInstance(Object[] args) {
        try {
            if (args.length == 0) {
                Constructor<?> noArgsConstructor = this.getDeclaredConstructor(this.getRawType());
                noArgsConstructor.setAccessible(true);
                return noArgsConstructor.newInstance(new Object[0]);
            }
            Class<?> rawType = this.getRawType();
            Optional<Constructor> constructor = Arrays.stream(rawType.getDeclaredConstructors()).filter(c -> !c.getDeclaringClass().equals(Class.class)).filter(c -> c.getParameterCount() == args.length).findAny();
            if (constructor.isPresent()) {
                Constructor c2 = constructor.get();
                c2.setAccessible(true);
                return c2.newInstance(args);
            }
            throw new RuntimeException("Could not find a suitable constructor of type " + String.valueOf(this.type));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("can't instantiate " + String.valueOf(this.type), e);
        }
    }

    private Constructor<?> getDeclaredConstructor(Class<?> type) throws NoSuchMethodException {
        return this.getDeclaredConstructor(type, new Class[0]);
    }

    private Constructor<?> getDeclaredConstructor(Class<?> type, Class<?>[] parameters) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return type.getDeclaredConstructor(parameters);
        }
        try {
            return AccessController.doPrivileged(() -> type.getDeclaredConstructor(parameters));
        }
        catch (PrivilegedActionException pae) {
            if (pae.getCause() instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)pae.getCause();
            }
            throw new RuntimeException(pae.getCause());
        }
    }

    public boolean isNonNull() {
        if (this.ifClass(c -> c.isPrimitive() || c.isAnnotationPresent(NonNull.class) || TypeInfo.isJakartaNotNull(c))) {
            return true;
        }
        if (this.annotatedType != null) {
            return this.annotatedType.isAnnotationPresent(NonNull.class) || TypeInfo.isJakartaNotNull(this.annotatedType);
        }
        if (this.container == null || !this.container.isCollection() || this.container.annotatedType == null) {
            return false;
        }
        return this.container.annotatedType.isAnnotationPresent(NonNull.class) || TypeInfo.isJakartaNotNull(this.container.annotatedType);
    }

    static boolean isJakartaNotNull(AnnotatedElement c) {
        return JAKARTA_NOT_NULL != null && c.isAnnotationPresent(JAKARTA_NOT_NULL);
    }

    public Class<?> getRawType() {
        if (this.rawType == null) {
            this.rawType = this.raw(this.type);
        }
        return this.rawType;
    }

    public TypeInfo getItemType() {
        assert (this.isCollection() || this.isOptional() || this.isErrorOr() || this.isAsync() || this.isTypesafeResponse());
        if (this.itemType == null) {
            this.itemType = new TypeInfo(this, this.computeParameterType(0), this.computeAnnotatedItemType());
        }
        return this.itemType;
    }

    public TypeInfo getKeyType() {
        if (this.keyType == null) {
            this.keyType = new TypeInfo(this, this.computeParameterType(0), this.computeAnnotatedItemType());
        }
        return this.keyType;
    }

    public TypeInfo getValueType() {
        if (this.valueType == null) {
            this.valueType = new TypeInfo(this, this.computeParameterType(1), this.computeAnnotatedItemType());
        }
        return this.valueType;
    }

    private Type computeParameterType(Integer index) {
        if (this.annotatedType instanceof AnnotatedParameterizedType) {
            return ((AnnotatedParameterizedType)this.annotatedType).getAnnotatedActualTypeArguments()[index].getType();
        }
        if (this.type instanceof ParameterizedType) {
            return ((ParameterizedType)this.type).getActualTypeArguments()[index];
        }
        if (this.genericType instanceof ParameterizedType) {
            return ((ParameterizedType)this.genericType).getActualTypeArguments()[index];
        }
        return ((Class)this.type).getComponentType();
    }

    private AnnotatedType computeAnnotatedItemType() {
        if (this.annotatedType instanceof AnnotatedParameterizedType) {
            return ((AnnotatedParameterizedType)this.annotatedType).getAnnotatedActualTypeArguments()[0];
        }
        return null;
    }

    private Class<?> raw(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return this.raw(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return this.resolveTypeVariable();
        }
        throw new RuntimeException("unsupported reflection type " + String.valueOf(type.getClass()));
    }

    public Optional<MethodInvocation> getMethod(String name, Class<?> ... args) {
        return this.getDeclaredMethod((Class)this.type, name, args).map(x$0 -> MethodInvocation.of(x$0, new Object[0]));
    }

    private Optional<Method> getDeclaredMethod(Class<?> type, String name, Class<?> ... args) {
        try {
            if (System.getSecurityManager() == null) {
                return Optional.of(type.getDeclaredMethod(name, args));
            }
            return Optional.of(AccessController.doPrivileged(() -> type.getDeclaredMethod(name, args)));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
        catch (PrivilegedActionException pae) {
            if (pae.getCause() instanceof NoSuchMethodException) {
                return Optional.empty();
            }
            throw new RuntimeException(pae.getCause());
        }
    }

    public boolean isNestedIn(TypeInfo that) {
        return this.enclosingTypes().anyMatch(that::equals);
    }

    public Stream<TypeInfo> enclosingTypes() {
        Stream.Builder<TypeInfo> builder = Stream.builder();
        for (Class<?> enclosing = this.getRawType(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
            builder.accept(TypeInfo.of(enclosing));
        }
        return builder.build();
    }

    public boolean isAnnotated(Class<? extends Annotation> type) {
        return this.ifClass(c -> c.isAnnotationPresent(type));
    }

    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return ((Class)this.type).getAnnotation(type);
    }

    public TypeInfo subtype(String typename) {
        return this.subtypes().filter(c -> c.getGraphQlTypeName().equals(typename)).findAny().orElseThrow(() -> SmallRyeGraphQLClientMessages.msg.cannotInstantiateDomainObject(typename, null));
    }

    public Stream<TypeInfo> subtypes() {
        JsonbTypeInfo jsonbTypeInfo = this.getAnnotation(JsonbTypeInfo.class);
        if (jsonbTypeInfo == null) {
            return Stream.empty();
        }
        return Stream.of(jsonbTypeInfo.value()).map(JsonbSubtype::type).map(TypeInfo::of);
    }
}

