/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx.websocket.graphqltransportws;

import io.smallrye.graphql.client.GraphQLClientException;
import io.smallrye.graphql.client.InvalidResponseException;
import io.smallrye.graphql.client.UnexpectedCloseException;
import io.smallrye.graphql.client.impl.JsonProviderHolder;
import io.smallrye.graphql.client.impl.ResponseReader;
import io.smallrye.graphql.client.vertx.websocket.WebSocketSubprotocolHandler;
import io.smallrye.graphql.client.vertx.websocket.graphqltransportws.MessageType;
import io.smallrye.graphql.client.vertx.websocket.opid.IncrementingNumberOperationIDGenerator;
import io.smallrye.graphql.client.vertx.websocket.opid.OperationIDGenerator;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.http.WebSocket;
import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParsingException;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class GraphQLTransportWSSubprotocolHandler
implements WebSocketSubprotocolHandler {
    private static final Logger log = Logger.getLogger(GraphQLTransportWSSubprotocolHandler.class);
    private static final JsonBuilderFactory jsonBuilderFactory = JsonProviderHolder.JSON_PROVIDER.createBuilderFactory(null);
    private static final JsonReaderFactory jsonReaderFactory = JsonProviderHolder.JSON_PROVIDER.createReaderFactory(null);
    private final Integer connectionInitializationTimeout;
    private JsonObject connectionInitMessage;
    private JsonObject pongMessage;
    private final WebSocket webSocket;
    private final CompletableFuture<Void> initialization;
    private final Map<String, UniEmitter<? super String>> uniOperations;
    private final Map<String, MultiEmitter<? super String>> multiOperations;
    private final Runnable onClose;
    private final OperationIDGenerator operationIdGenerator;
    private final Map<String, Object> initPayload = new HashMap<String, Object>();

    public GraphQLTransportWSSubprotocolHandler(WebSocket webSocket, Integer subscriptionInitializationTimeout, Map<String, Object> initPayload, Runnable onClose) {
        if (initPayload != null) {
            this.initPayload.putAll(initPayload);
        }
        this.webSocket = webSocket;
        this.connectionInitializationTimeout = subscriptionInitializationTimeout;
        this.uniOperations = new ConcurrentHashMap<String, UniEmitter<? super String>>();
        this.multiOperations = new ConcurrentHashMap<String, MultiEmitter<? super String>>();
        this.initialization = this.initialize().subscribeAsCompletionStage();
        this.onClose = onClose;
        this.operationIdGenerator = new IncrementingNumberOperationIDGenerator();
    }

    @Override
    public Uni<Void> ensureInitialized() {
        return Uni.createFrom().completionStage(this.initialization);
    }

    private Uni<Void> initialize() {
        return Uni.createFrom().emitter(initializationEmitter -> {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Initializing websocket with graphql-transport-ws protocol");
            }
            JsonObjectBuilder payloadBuilder = jsonBuilderFactory.createObjectBuilder();
            if (!this.initPayload.isEmpty()) {
                payloadBuilder.add("payload", jsonBuilderFactory.createObjectBuilder(this.initPayload));
            }
            this.connectionInitMessage = jsonBuilderFactory.createObjectBuilder().add("type", "connection_init").addAll(payloadBuilder).build();
            this.pongMessage = jsonBuilderFactory.createObjectBuilder().add("type", "pong").add("payload", jsonBuilderFactory.createObjectBuilder().add("message", "keepalive")).build();
            this.webSocket.closeHandler(v -> {
                InvalidResponseException exception;
                this.onClose.run();
                if (this.webSocket.closeStatusCode() != null) {
                    if (this.webSocket.closeStatusCode() == 1000) {
                        log.debug((Object)"WebSocket closed with status code 1000");
                        exception = new UnexpectedCloseException("Connection closed before data was received", 1000);
                        this.uniOperations.forEach((arg_0, arg_1) -> GraphQLTransportWSSubprotocolHandler.lambda$initialize$0((Exception)exception, arg_0, arg_1));
                        this.multiOperations.forEach((id, emitter) -> emitter.complete());
                    } else {
                        exception = new UnexpectedCloseException("Server closed the websocket connection with code: " + this.webSocket.closeStatusCode() + " and reason: " + this.webSocket.closeReason(), (int)this.webSocket.closeStatusCode().shortValue());
                        this.uniOperations.forEach((arg_0, arg_1) -> GraphQLTransportWSSubprotocolHandler.lambda$initialize$2((Exception)exception, arg_0, arg_1));
                        this.multiOperations.forEach((arg_0, arg_1) -> GraphQLTransportWSSubprotocolHandler.lambda$initialize$3((Exception)exception, arg_0, arg_1));
                    }
                } else {
                    exception = new InvalidResponseException("Connection closed");
                    this.uniOperations.forEach((arg_0, arg_1) -> GraphQLTransportWSSubprotocolHandler.lambda$initialize$4((Exception)exception, arg_0, arg_1));
                    this.multiOperations.forEach((arg_0, arg_1) -> GraphQLTransportWSSubprotocolHandler.lambda$initialize$5((Exception)exception, arg_0, arg_1));
                }
                initializationEmitter.fail((Throwable)exception);
            });
            this.webSocket.exceptionHandler(this::failAllActiveOperationsWith);
            this.send(this.webSocket, this.connectionInitMessage);
            Cancellable timeoutWaitingForConnectionAckMessage = null;
            if (this.connectionInitializationTimeout != null) {
                timeoutWaitingForConnectionAckMessage = Uni.createFrom().item((Object)1).onItem().delayIt().by(Duration.ofMillis(this.connectionInitializationTimeout.intValue())).subscribe().with(timeout -> {
                    initializationEmitter.fail((Throwable)new InvalidResponseException("Server did not send a connection_ack message"));
                    this.webSocket.close((short)1002, "Timeout waiting for a connection_ack message");
                });
            }
            Cancellable finalTimeoutWaitingForConnectionAckMessage = timeoutWaitingForConnectionAckMessage;
            this.webSocket.textMessageHandler(text -> {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("<<< " + text));
                }
                try {
                    JsonObject message = this.parseIncomingMessage((String)text);
                    MessageType messageType = this.getMessageType(message);
                    switch (messageType) {
                        case PING: {
                            this.send(this.webSocket, this.pongMessage);
                            break;
                        }
                        case CONNECTION_ACK: {
                            if (finalTimeoutWaitingForConnectionAckMessage != null) {
                                finalTimeoutWaitingForConnectionAckMessage.cancel();
                            }
                            initializationEmitter.complete(null);
                            break;
                        }
                        case NEXT: {
                            this.handleData(message.getString("id"), message.getJsonObject("payload"));
                            break;
                        }
                        case ERROR: {
                            this.handleOperationError(message.getString("id"), message.getJsonArray("payload"));
                            break;
                        }
                        case COMPLETE: {
                            this.handleComplete(message.getString("id"));
                            break;
                        }
                    }
                }
                catch (JsonParsingException | IllegalArgumentException e) {
                    log.error((Object)("Unexpected message from server: " + text));
                }
            });
        });
    }

    private void handleData(String operationId, JsonObject data) {
        UniEmitter<? super String> uniEmitter = this.uniOperations.remove(operationId);
        if (uniEmitter != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Received data for single-result operation " + operationId));
            }
            uniEmitter.complete((Object)data.toString());
        } else {
            MultiEmitter<? super String> multiEmitter = this.multiOperations.get(operationId);
            if (multiEmitter != null) {
                if (multiEmitter.isCancelled()) {
                    log.warn((Object)("Received data for already cancelled operation " + operationId));
                } else {
                    multiEmitter.emit((Object)data.toString());
                }
            } else {
                log.warn((Object)("Received event for an unknown subscription ID: " + operationId));
            }
        }
    }

    private void handleOperationError(String operationId, JsonArray errors) {
        List parsedErrors = errors.stream().map(ResponseReader::readError).collect(Collectors.toList());
        GraphQLClientException exception = new GraphQLClientException("Received an error", parsedErrors);
        UniEmitter<? super String> emitter = this.uniOperations.remove(operationId);
        if (emitter != null) {
            emitter.fail((Throwable)exception);
        } else {
            MultiEmitter<? super String> multiEmitter = this.multiOperations.remove(operationId);
            if (multiEmitter != null) {
                multiEmitter.fail((Throwable)exception);
            }
        }
    }

    private void handleComplete(String operationId) {
        UniEmitter<? super String> emitter = this.uniOperations.remove(operationId);
        if (emitter != null) {
            emitter.fail((Throwable)new InvalidResponseException("Protocol error: received a 'complete' message for this operation before the actual data"));
        } else {
            MultiEmitter<? super String> multiEmitter = this.multiOperations.remove(operationId);
            if (multiEmitter != null) {
                log.debug((Object)("Completed operation " + operationId));
                multiEmitter.complete();
            }
        }
    }

    private void failAllActiveOperationsWith(Throwable throwable) {
        UniEmitter<? super String> emitter;
        log.debug((Object)"Failing all active operations");
        for (String s : this.uniOperations.keySet()) {
            emitter = this.uniOperations.remove(s);
            if (emitter == null) continue;
            emitter.fail(throwable);
        }
        for (String s : this.multiOperations.keySet()) {
            emitter = this.multiOperations.remove(s);
            if (emitter == null) continue;
            emitter.fail(throwable);
        }
    }

    @Override
    public String executeUni(JsonObject request, UniEmitter<? super String> emitter) {
        String id = this.operationIdGenerator.generate();
        this.ensureInitialized().subscribe().with(ready -> {
            this.uniOperations.put(id, emitter);
            JsonObject subscribe = this.createSubscribeMessage(request, id);
            this.send(this.webSocket, subscribe);
        }, arg_0 -> emitter.fail(arg_0));
        return id;
    }

    @Override
    public String executeMulti(JsonObject request, MultiEmitter<? super String> emitter) {
        String id = this.operationIdGenerator.generate();
        this.ensureInitialized().subscribe().with(ready -> {
            this.multiOperations.put(id, emitter);
            JsonObject subscribe = this.createSubscribeMessage(request, id);
            this.send(this.webSocket, subscribe);
        }, arg_0 -> emitter.fail(arg_0));
        return id;
    }

    @Override
    public void cancelUni(String id) {
        this.uniOperations.remove(id);
        this.send(this.webSocket, this.createCompleteMessage(id));
    }

    @Override
    public void cancelMulti(String id) {
        this.multiOperations.remove(id);
        this.send(this.webSocket, this.createCompleteMessage(id));
    }

    @Override
    public void close() {
        if (this.webSocket != null && !this.webSocket.isClosed()) {
            this.webSocket.close((short)1000);
        }
    }

    private MessageType getMessageType(JsonObject message) {
        return MessageType.fromString(message.getString("type"));
    }

    private JsonObject parseIncomingMessage(String message) {
        try (JsonReader jsonReader = jsonReaderFactory.createReader((Reader)new StringReader(message));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }

    private JsonObject createSubscribeMessage(JsonObject request, String id) {
        JsonObject variables;
        JsonObjectBuilder payload = jsonBuilderFactory.createObjectBuilder();
        payload.add("query", request.getString("query"));
        JsonValue operationName = (JsonValue)request.get((Object)"operationName");
        if (operationName instanceof JsonString) {
            payload.add("operationName", operationName);
        }
        if ((variables = request.getJsonObject("variables")) != null) {
            payload.add("variables", (JsonValue)variables);
        }
        return jsonBuilderFactory.createObjectBuilder().add("type", "subscribe").add("id", id).add("payload", payload).build();
    }

    private JsonObject createCompleteMessage(String id) {
        return jsonBuilderFactory.createObjectBuilder().add("type", "complete").add("id", id).build();
    }

    private Uni<Void> send(WebSocket webSocket, JsonObject message) {
        String string = message.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)(">>> " + string));
        }
        return Uni.createFrom().completionStage(webSocket.writeTextMessage(string).toCompletionStage());
    }

    private static /* synthetic */ void lambda$initialize$5(Exception exception, String id, MultiEmitter emitter) {
        emitter.fail((Throwable)exception);
    }

    private static /* synthetic */ void lambda$initialize$4(Exception exception, String id, UniEmitter emitter) {
        emitter.fail((Throwable)exception);
    }

    private static /* synthetic */ void lambda$initialize$3(Exception exception, String id, MultiEmitter emitter) {
        emitter.fail((Throwable)exception);
    }

    private static /* synthetic */ void lambda$initialize$2(Exception exception, String id, UniEmitter emitter) {
        emitter.fail((Throwable)exception);
    }

    private static /* synthetic */ void lambda$initialize$0(Exception exception, String id, UniEmitter emitter) {
        emitter.fail((Throwable)exception);
    }
}

