/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.api.federation;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.graphql.api.Directive;
import io.smallrye.graphql.api.DirectiveLocation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.eclipse.microprofile.graphql.Description;
import org.eclipse.microprofile.graphql.NonNull;

@Directive(on={DirectiveLocation.FIELD_DEFINITION})
@Retention(value=RetentionPolicy.RUNTIME)
@Description(value="Indicates that an object field is now resolved by this subgraph instead of another subgraph where it's also defined. This enables you to migrate a field from one subgraph to another.\nYou can apply @override to entity fields and fields of the root operation types (such as Query and Mutation).")
@Experimental(value="SmallRye GraphQL Federation is still subject to change.")
public @interface Override {
    @NonNull
    @Description(value="The name of the other subgraph that no longer resolves the field.\nIf you're performing composition with managed federation, this must match the name of the subgraph in Apollo Studio.\nIf you're performing composition with the Rover CLI, this must match the name of the subgraph in the YAML config file you provide to rover supergraph compose.")
    public String from();

    @Description(value="A string of arbitrary arguments. Currently supported:\npercent(<percent-value>) - The percentage of traffic for the field that's resolved by this subgraph. The remaining percentage is resolved by the other (from) subgraph.")
    public String label() default "";
}

