/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.tracing;

import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.concurrent.Callable;

public class TracingConcurrencyStrategy
extends HystrixConcurrencyStrategy {
    private HystrixConcurrencyStrategy delegateStrategy;
    private Tracer tracer;

    public TracingConcurrencyStrategy(HystrixConcurrencyStrategy delegateStrategy, Tracer tracer) {
        this.tracer = tracer;
        this.delegateStrategy = delegateStrategy;
    }

    public <T> Callable<T> wrapCallable(Callable<T> callable) {
        Callable delegateCallable;
        if (callable instanceof OpenTracingHystrixCallable) {
            return callable;
        }
        Callable callable2 = delegateCallable = this.delegateStrategy == null ? callable : this.delegateStrategy.wrapCallable(callable);
        if (delegateCallable instanceof OpenTracingHystrixCallable) {
            return delegateCallable;
        }
        if (this.tracer.scopeManager().active() == null) {
            return delegateCallable;
        }
        return new OpenTracingHystrixCallable(delegateCallable, this.tracer.scopeManager(), this.tracer.scopeManager().active().span());
    }

    private static class OpenTracingHystrixCallable<S>
    implements Callable<S> {
        private final Callable<S> delegateCallable;
        private ScopeManager scopeManager;
        private Span span;

        public OpenTracingHystrixCallable(Callable<S> delegate, ScopeManager scopeManager, Span span) {
            if (span == null || delegate == null || scopeManager == null) {
                throw new NullPointerException();
            }
            this.delegateCallable = delegate;
            this.scopeManager = scopeManager;
            this.span = span;
        }

        @Override
        public S call() throws Exception {
            try (Scope scope = this.scopeManager.activate(this.span, false);){
                S s = this.delegateCallable.call();
                return s;
            }
        }
    }
}

