/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedThreadFactory;
import javax.enterprise.context.Dependent;
import org.jboss.logging.Logger;

@Dependent
public class DefaultHystrixConcurrencyStrategy
extends HystrixConcurrencyStrategy {
    private static final Logger LOGGER = Logger.getLogger(DefaultHystrixConcurrencyStrategy.class);
    @Resource(lookup="java:comp/DefaultManagedThreadFactory")
    ManagedThreadFactory managedThreadFactory;
    ThreadFactory threadFactory;

    @PostConstruct
    public void initTreadManagerFactory() {
        if (this.managedThreadFactory != null) {
            this.threadFactory = this.managedThreadFactory;
            LOGGER.debug((Object)"### Managed Thread Factory used ###");
        } else {
            this.threadFactory = Executors.privilegedThreadFactory();
            LOGGER.debug((Object)"### Privilleged Thread Factory used ###");
        }
    }

    public ThreadPoolExecutor getThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixProperty<Integer> corePoolSize, HystrixProperty<Integer> maximumPoolSize, HystrixProperty<Integer> keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        int dynamicCoreSize = (Integer)corePoolSize.get();
        int dynamicMaximumSize = (Integer)maximumPoolSize.get();
        LOGGER.debugf("Get thread pool executor for %s [core: %s, max: %s]", (Object)threadPoolKey.name(), (Object)dynamicCoreSize, (Object)dynamicMaximumSize);
        return new ThreadPoolExecutor(dynamicCoreSize, dynamicCoreSize > dynamicMaximumSize ? dynamicCoreSize : dynamicMaximumSize, (long)((Integer)keepAliveTime.get()).intValue(), unit, workQueue, this.threadFactory);
    }

    public ThreadPoolExecutor getThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties threadPoolProperties) {
        boolean allowMaximumSizeToDivergeFromCoreSize = (Boolean)threadPoolProperties.getAllowMaximumSizeToDivergeFromCoreSize().get();
        int dynamicCoreSize = (Integer)threadPoolProperties.coreSize().get();
        int dynamicMaximumSize = (Integer)threadPoolProperties.maximumSize().get();
        int keepAliveTime = (Integer)threadPoolProperties.keepAliveTimeMinutes().get();
        int maxQueueSize = (Integer)threadPoolProperties.maxQueueSize().get();
        BlockingQueue workQueue = this.getBlockingQueue(maxQueueSize);
        LOGGER.debugf("Get thread pool executor for %s [allowMaximumSizeToDivergeFromCoreSize: %s, core: %s, max: %s]", new Object[]{threadPoolKey.name(), allowMaximumSizeToDivergeFromCoreSize, dynamicCoreSize, dynamicMaximumSize});
        if (allowMaximumSizeToDivergeFromCoreSize) {
            return new ThreadPoolExecutor(dynamicCoreSize, dynamicCoreSize > dynamicMaximumSize ? dynamicCoreSize : dynamicMaximumSize, (long)keepAliveTime, TimeUnit.MINUTES, (BlockingQueue<Runnable>)workQueue, this.threadFactory);
        }
        return new ThreadPoolExecutor(dynamicCoreSize, dynamicCoreSize, (long)keepAliveTime, TimeUnit.MINUTES, (BlockingQueue<Runnable>)workQueue, this.threadFactory);
    }
}

