/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.tracing;

import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import io.opentracing.util.GlobalTracer;
import io.smallrye.faulttolerance.tracing.TracingConcurrencyStrategy;
import org.jboss.logging.Logger;

public class TracingInstaller {
    private static final Logger LOGGER = Logger.getLogger(TracingInstaller.class);

    private TracingInstaller() {
    }

    public static HystrixConcurrencyStrategy wrap(HystrixConcurrencyStrategy concurrencyStrategy) {
        try {
            Class.forName("io.opentracing.Tracer");
            return new TracingConcurrencyStrategy(concurrencyStrategy, GlobalTracer.get());
        }
        catch (ClassNotFoundException | LinkageError e) {
            LOGGER.debug((Object)"OpenTracing is not on classpath, skipping context propagation instrumentation");
            return concurrencyStrategy;
        }
    }
}

