/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.config.SecurityActions;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public abstract class GenericConfig<X extends Annotation> {
    public static final String CONFIG_PARAMS_CACHE_KEY = "org_wildfly_swarm_microprofile_faulttolerance_configParamsCache";
    protected final Class<?> beanClass;
    protected final Method method;
    protected final X annotation;
    protected final Class<X> annotationType;
    protected final AnnotatedMethod<?> annotatedMethod;
    protected final ElementType annotationSource;
    private final Map<String, Object> values;

    public GenericConfig(Class<X> annotationType, Class<?> beanClass, Method method) {
        this(beanClass, method, null, annotationType, method.isAnnotationPresent(annotationType) ? method.getAnnotation(annotationType) : GenericConfig.getAnnotationFromClass(annotationType, beanClass), method.isAnnotationPresent(annotationType) ? ElementType.METHOD : ElementType.TYPE);
    }

    public GenericConfig(Class<X> annotationType, AnnotatedMethod<?> annotatedMethod) {
        this(annotatedMethod.getDeclaringType().getJavaClass(), annotatedMethod.getJavaMember(), annotatedMethod, annotationType, annotatedMethod.isAnnotationPresent(annotationType) ? annotatedMethod.getAnnotation(annotationType) : annotatedMethod.getDeclaringType().getAnnotation(annotationType), annotatedMethod.isAnnotationPresent(annotationType) ? ElementType.METHOD : ElementType.TYPE);
    }

    private GenericConfig(Class<?> beanClass, Method method, AnnotatedMethod<?> annotatedMethod, Class<X> annotationType, X annotation, ElementType annotationSource) {
        this.beanClass = beanClass;
        this.method = method;
        this.annotatedMethod = annotatedMethod;
        this.annotationType = annotationType;
        this.annotation = annotation;
        this.annotationSource = annotationSource;
        this.values = GenericConfig.getConfig().getOptionalValue(CONFIG_PARAMS_CACHE_KEY, Boolean.class).orElse(true) != false ? new ConcurrentHashMap() : null;
    }

    public <U> U get(String key) {
        if (this.values != null) {
            return (U)this.values.computeIfAbsent(key, k -> this.lookup((String)k, (Class)this.getKeysToType().get(key)));
        }
        Class<?> expectedType = this.getKeysToType().get(key);
        return (U)this.lookup(key, expectedType);
    }

    public <U> U get(String key, Class<U> expectedType) {
        if (this.values != null) {
            return (U)this.values.computeIfAbsent(key, k -> this.lookup((String)k, expectedType));
        }
        return this.lookup(key, expectedType);
    }

    private <U> U lookup(String key, Class<U> expectedType) {
        Config config = GenericConfig.getConfig();
        Optional value = null;
        value = ElementType.METHOD.equals((Object)this.annotationSource) ? config.getOptionalValue(this.getConfigKeyForMethod() + key, expectedType) : config.getOptionalValue(this.getConfigKeyForClass() + key, expectedType);
        if (!value.isPresent()) {
            value = config.getOptionalValue(this.annotationType.getSimpleName() + "/" + key, expectedType);
        }
        return (U)(value.isPresent() ? value.get() : this.getConfigFromAnnotation(key));
    }

    public abstract void validate();

    private <U> U getConfigFromAnnotation(String key) {
        try {
            return (U)SecurityActions.getAnnotationMethod(this.annotationType, key).invoke(this.annotation, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException | PrivilegedActionException e) {
            throw new FaultToleranceDefinitionException("Member " + key + " on annotation " + this.annotation.getClass().toString() + " doesn't exist or is not accessible");
        }
    }

    protected String getConfigKeyForMethod() {
        return this.method.getDeclaringClass().getName() + "/" + this.method.getName() + "/" + this.annotationType.getSimpleName() + "/";
    }

    protected String getConfigKeyForClass() {
        return this.method.getDeclaringClass().getName() + "/" + this.annotationType.getSimpleName() + "/";
    }

    public String getMethodInfo() {
        return this.annotatedMethod != null ? this.annotatedMethod.toString() : this.method.toGenericString();
    }

    protected static Config getConfig() {
        return ConfigProvider.getConfig();
    }

    private static <A extends Annotation> A getAnnotationFromClass(Class<A> annotationType, Class<?> beanClass) {
        while (beanClass != Object.class) {
            A annotation = beanClass.getAnnotation(annotationType);
            if (annotation != null) {
                return annotation;
            }
            beanClass = beanClass.getSuperclass();
        }
        throw new IllegalStateException(annotationType + " not found on " + beanClass);
    }

    protected abstract Map<String, Class<?>> getKeysToType();
}

