/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import io.smallrye.faulttolerance.FaultToleranceCommandExecutionHook;
import io.smallrye.faulttolerance.tracing.TracingInstaller;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.logging.Logger;

@ApplicationScoped
public class HystrixInitializer {
    private static final Logger LOGGER = Logger.getLogger(HystrixInitializer.class);
    @Inject
    Instance<HystrixConcurrencyStrategy> instance;

    void init(@Observes @Initialized(value=ApplicationScoped.class) Object event) {
    }

    @PostConstruct
    void onStartup() {
        LOGGER.info((Object)"### Init Hystrix ###");
        HystrixConcurrencyStrategy strategy = (HystrixConcurrencyStrategy)this.instance.get();
        LOGGER.info((Object)("Hystrix concurrency strategy used: " + strategy.getClass().getSimpleName()));
        HystrixPlugins.getInstance().registerConcurrencyStrategy(TracingInstaller.wrap(strategy));
        HystrixPlugins.getInstance().registerCommandExecutionHook((HystrixCommandExecutionHook)new FaultToleranceCommandExecutionHook());
    }

    @PreDestroy
    void onShutdown() {
        LOGGER.info((Object)"### Reset Hystrix ###");
        Hystrix.reset((long)1L, (TimeUnit)TimeUnit.SECONDS);
    }
}

