/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.basicconfig.CircuitBreakerConfig;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class CircuitBreakerConfigImpl
implements CircuitBreakerConfig {
    private final String description;
    private final String configKey;
    private final CircuitBreaker instance;
    private Class<? extends Throwable>[] _failOn;
    private Class<? extends Throwable>[] _skipOn;
    private Long _delay;
    private ChronoUnit _delayUnit;
    private Integer _requestVolumeThreshold;
    private Double _failureRatio;
    private Integer _successThreshold;

    private CircuitBreakerConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(CircuitBreaker.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.circuitBreaker;
    }

    private CircuitBreakerConfigImpl(String id, CircuitBreaker instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static CircuitBreakerConfigImpl create(FaultToleranceMethod method) {
        if (method.circuitBreaker == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("circuit-breaker.enabled", "CircuitBreaker/enabled", method.method)) {
            return null;
        }
        return new CircuitBreakerConfigImpl(method);
    }

    public static CircuitBreakerConfigImpl create(String id, Supplier<CircuitBreaker> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("circuit-breaker.enabled", "CircuitBreaker/enabled", id)) {
            return null;
        }
        return new CircuitBreakerConfigImpl(id, supplier.get());
    }

    public Class<? extends Annotation> annotationType() {
        return CircuitBreaker.class;
    }

    public Class<? extends Throwable>[] failOn() {
        if (this._failOn == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.fail-on";
            Object oldKey = this.configKey + "/CircuitBreaker/failOn";
            this._failOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> CircuitBreakerConfigImpl.lambda$failOn$0(config, (String)oldKey)).orElse(null);
            if (this._failOn == null) {
                newKey = "smallrye.faulttolerance.global.circuit-breaker.fail-on";
                oldKey = "CircuitBreaker/failOn";
                this._failOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> CircuitBreakerConfigImpl.lambda$failOn$1(config, (String)oldKey)).orElse(null);
            }
            if (this._failOn == null) {
                this._failOn = this.instance.failOn();
            }
        }
        return this._failOn;
    }

    public Class<? extends Throwable>[] skipOn() {
        if (this._skipOn == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.skip-on";
            Object oldKey = this.configKey + "/CircuitBreaker/skipOn";
            this._skipOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> CircuitBreakerConfigImpl.lambda$skipOn$2(config, (String)oldKey)).orElse(null);
            if (this._skipOn == null) {
                newKey = "smallrye.faulttolerance.global.circuit-breaker.skip-on";
                oldKey = "CircuitBreaker/skipOn";
                this._skipOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> CircuitBreakerConfigImpl.lambda$skipOn$3(config, (String)oldKey)).orElse(null);
            }
            if (this._skipOn == null) {
                this._skipOn = this.instance.skipOn();
            }
        }
        return this._skipOn;
    }

    public long delay() {
        if (this._delay == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.delay";
            Object oldKey = this.configKey + "/CircuitBreaker/delay";
            this._delay = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> CircuitBreakerConfigImpl.lambda$delay$4(config, (String)oldKey)).orElse(null);
            if (this._delay == null) {
                newKey = "smallrye.faulttolerance.global.circuit-breaker.delay";
                oldKey = "CircuitBreaker/delay";
                this._delay = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> CircuitBreakerConfigImpl.lambda$delay$5(config, (String)oldKey)).orElse(null);
            }
            if (this._delay == null) {
                this._delay = this.instance.delay();
            }
        }
        return this._delay;
    }

    public ChronoUnit delayUnit() {
        if (this._delayUnit == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.delay-unit";
            Object oldKey = this.configKey + "/CircuitBreaker/delayUnit";
            this._delayUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> CircuitBreakerConfigImpl.lambda$delayUnit$6(config, (String)oldKey)).orElse(null);
            if (this._delayUnit == null) {
                newKey = "smallrye.faulttolerance.global.circuit-breaker.delay-unit";
                oldKey = "CircuitBreaker/delayUnit";
                this._delayUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> CircuitBreakerConfigImpl.lambda$delayUnit$7(config, (String)oldKey)).orElse(null);
            }
            if (this._delayUnit == null) {
                this._delayUnit = this.instance.delayUnit();
            }
        }
        return this._delayUnit;
    }

    public int requestVolumeThreshold() {
        if (this._requestVolumeThreshold == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.request-volume-threshold";
            Object oldKey = this.configKey + "/CircuitBreaker/requestVolumeThreshold";
            this._requestVolumeThreshold = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> CircuitBreakerConfigImpl.lambda$requestVolumeThreshold$8(config, (String)oldKey)).orElse(null);
            if (this._requestVolumeThreshold == null) {
                newKey = "smallrye.faulttolerance.global.circuit-breaker.request-volume-threshold";
                oldKey = "CircuitBreaker/requestVolumeThreshold";
                this._requestVolumeThreshold = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> CircuitBreakerConfigImpl.lambda$requestVolumeThreshold$9(config, (String)oldKey)).orElse(null);
            }
            if (this._requestVolumeThreshold == null) {
                this._requestVolumeThreshold = this.instance.requestVolumeThreshold();
            }
        }
        return this._requestVolumeThreshold;
    }

    public double failureRatio() {
        if (this._failureRatio == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.failure-ratio";
            Object oldKey = this.configKey + "/CircuitBreaker/failureRatio";
            this._failureRatio = config.getOptionalValue((String)newKey, Double.TYPE).or(() -> CircuitBreakerConfigImpl.lambda$failureRatio$10(config, (String)oldKey)).orElse(null);
            if (this._failureRatio == null) {
                newKey = "smallrye.faulttolerance.global.circuit-breaker.failure-ratio";
                oldKey = "CircuitBreaker/failureRatio";
                this._failureRatio = config.getOptionalValue((String)newKey, Double.TYPE).or(() -> CircuitBreakerConfigImpl.lambda$failureRatio$11(config, (String)oldKey)).orElse(null);
            }
            if (this._failureRatio == null) {
                this._failureRatio = this.instance.failureRatio();
            }
        }
        return this._failureRatio;
    }

    public int successThreshold() {
        if (this._successThreshold == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.success-threshold";
            Object oldKey = this.configKey + "/CircuitBreaker/successThreshold";
            this._successThreshold = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> CircuitBreakerConfigImpl.lambda$successThreshold$12(config, (String)oldKey)).orElse(null);
            if (this._successThreshold == null) {
                newKey = "smallrye.faulttolerance.global.circuit-breaker.success-threshold";
                oldKey = "CircuitBreaker/successThreshold";
                this._successThreshold = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> CircuitBreakerConfigImpl.lambda$successThreshold$13(config, (String)oldKey)).orElse(null);
            }
            if (this._successThreshold == null) {
                this._successThreshold = this.instance.successThreshold();
            }
        }
        return this._successThreshold;
    }

    public void materialize() {
        this.failOn();
        this.skipOn();
        this.delay();
        this.delayUnit();
        this.requestVolumeThreshold();
        this.failureRatio();
        this.successThreshold();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @CircuitBreaker on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @CircuitBreaker." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$successThreshold$13(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }

    private static /* synthetic */ Optional lambda$successThreshold$12(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }

    private static /* synthetic */ Optional lambda$failureRatio$11(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Double.TYPE);
    }

    private static /* synthetic */ Optional lambda$failureRatio$10(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Double.TYPE);
    }

    private static /* synthetic */ Optional lambda$requestVolumeThreshold$9(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }

    private static /* synthetic */ Optional lambda$requestVolumeThreshold$8(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }

    private static /* synthetic */ Optional lambda$delayUnit$7(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$delayUnit$6(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$delay$5(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$delay$4(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$skipOn$3(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }

    private static /* synthetic */ Optional lambda$skipOn$2(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }

    private static /* synthetic */ Optional lambda$failOn$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }

    private static /* synthetic */ Optional lambda$failOn$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }
}

