/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.apiimpl;

import io.smallrye.faulttolerance.api.TypedGuard;
import io.smallrye.faulttolerance.apiimpl.TypedGuardImpl;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;

public final class LazyTypedGuard<V, T>
implements TypedGuard<T> {
    private final Function<String, TypedGuardImpl<V, T>> builder;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile TypedGuardImpl<V, T> instance;

    LazyTypedGuard(Function<String, TypedGuardImpl<V, T>> builder) {
        this.builder = builder;
    }

    public T call(Callable<T> action) throws Exception {
        return this.instance(null).call(action);
    }

    public T get(Supplier<T> action) {
        return this.instance(null).get(action);
    }

    public TypedGuardImpl<V, T> instance(String identifier) {
        TypedGuardImpl<V, T> instance = this.instance;
        if (instance == null) {
            this.lock.lock();
            try {
                instance = this.instance;
                if (instance == null) {
                    this.instance = instance = this.builder.apply(identifier);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return instance;
    }
}

