/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.application.context.propagation;

import java.security.AccessController;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class ApplicationContextProvider
implements ThreadContextProvider {
    static final ClassLoader SYSTEM_CL;

    private static ClassLoader calculateSystemClassLoader() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        if (cl == null) {
            cl = new ClassLoader(null){};
        }
        return cl;
    }

    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        ClassLoader capturedTCCL = Thread.currentThread().getContextClassLoader();
        return () -> {
            ClassLoader movedTCCL = Thread.currentThread().getContextClassLoader();
            if (capturedTCCL != movedTCCL) {
                Thread.currentThread().setContextClassLoader(capturedTCCL);
            }
            return () -> {
                if (Thread.currentThread().getContextClassLoader() != movedTCCL) {
                    Thread.currentThread().setContextClassLoader(movedTCCL);
                }
            };
        };
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        ClassLoader capturedTCCL = SYSTEM_CL;
        return () -> {
            ClassLoader movedTCCL = Thread.currentThread().getContextClassLoader();
            if (capturedTCCL != movedTCCL) {
                Thread.currentThread().setContextClassLoader(capturedTCCL);
            }
            return () -> {
                if (Thread.currentThread().getContextClassLoader() != movedTCCL) {
                    Thread.currentThread().setContextClassLoader(movedTCCL);
                }
            };
        };
    }

    public String getThreadContextType() {
        return "Application";
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        SYSTEM_CL = sm != null ? AccessController.doPrivileged(ApplicationContextProvider::calculateSystemClassLoader) : ApplicationContextProvider.calculateSystemClassLoader();
    }
}

