/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.utils.recovery;

import io.reactivex.internal.subscribers.SinglePostCompleteSubscriber;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Subscriber;

public class OnErrorReturnSubscriber<T>
extends SinglePostCompleteSubscriber<T, T> {
    private static final long serialVersionUID = 1111111L;
    private final transient Function<? super Throwable, ? extends T> valueSupplier;

    OnErrorReturnSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends T> valueSupplier) {
        super(actual);
        this.valueSupplier = valueSupplier;
    }

    public void onNext(T t) {
        ++this.produced;
        this.downstream.onNext(t);
    }

    public void onError(Throwable t) {
        T v;
        try {
            v = Objects.requireNonNull(this.valueSupplier.apply(t), "The valueSupplier returned a null value");
        }
        catch (Exception ex) {
            this.downstream.onError((Throwable)ex);
            return;
        }
        this.complete(v);
    }

    public void onComplete() {
        this.downstream.onComplete();
    }
}

