/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.stages;

import io.reactivex.Flowable;
import io.smallrye.reactive.streams.Engine;
import io.smallrye.reactive.streams.operators.ProcessingStage;
import io.smallrye.reactive.streams.operators.ProcessingStageFactory;
import io.smallrye.reactive.streams.utils.Casts;
import io.smallrye.reactive.streams.utils.CompletionStageToPublisher;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;

public class FlatMapCompletionStageFactory
implements ProcessingStageFactory<Stage.FlatMapCompletionStage> {
    @Override
    public <I, O> ProcessingStage<I, O> create(Engine engine, Stage.FlatMapCompletionStage stage) {
        Function mapper = Casts.cast(Objects.requireNonNull(stage).getMapper());
        return new FlatMapCompletionStage(mapper);
    }

    private static class FlatMapCompletionStage<I, O>
    implements ProcessingStage<I, O> {
        private final Function<I, CompletionStage<O>> mapper;

        private FlatMapCompletionStage(Function<I, CompletionStage<O>> mapper) {
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public Flowable<O> apply(Flowable<I> source) {
            return source.flatMap(item -> {
                if (item == null) {
                    throw new NullPointerException();
                }
                CompletionStage<O> result = this.mapper.apply(item);
                if (result == null) {
                    throw new NullPointerException();
                }
                return CompletionStageToPublisher.fromCompletionStage(result, false);
            }, 1);
        }
    }
}

