package io.smallrye.reactive.messaging.providers.i18n;

import java.util.Locale;
import java.io.Serializable;
import java.lang.String;

/**
 * Warning this class consists of generated code.
 */
public class ProviderMessages_$bundle implements ProviderMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected ProviderMessages_$bundle() {}
    public static final ProviderMessages_$bundle INSTANCE = new ProviderMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invokerNotInitialized$str() {
        return "SRMSG00100: Invoker not initialized";
    }
    @Override
    public final String invokerNotInitialized() {
        return String.format(getLoggingLocale(), invokerNotInitialized$str());
    }
    protected String workerPoolNotInitialized$str() {
        return "SRMSG00101: Worker pool not initialized";
    }
    @Override
    public final String workerPoolNotInitialized() {
        return String.format(getLoggingLocale(), workerPoolNotInitialized$str());
    }
    protected String nameMustBeSet$str() {
        return "SRMSG00102: 'name' must be set";
    }
    @Override
    public final String nameMustBeSet() {
        return String.format(getLoggingLocale(), nameMustBeSet$str());
    }
    protected String methodCallingExceptionMessage$str() {
        return "SRMSG00103: Exception thrown when calling the method %s";
    }
    @Override
    public final String methodCallingExceptionMessage(final String method) {
        return String.format(getLoggingLocale(), methodCallingExceptionMessage$str(), method);
    }
    protected String methodReturnedNull$str() {
        return "SRMSG00104: The method %s returned `null`";
    }
    @Override
    public final String methodReturnedNull(final String methodAsString) {
        return String.format(getLoggingLocale(), methodReturnedNull$str(), methodAsString);
    }
    protected String weavingSynchronousError$str() {
        return "SRMSG00105: Synchronous error caught during the subscription of `%s`";
    }
    @Override
    public final String weavingSynchronousError(final String sources) {
        return String.format(getLoggingLocale(), weavingSynchronousError$str(), sources);
    }
    protected String weavingUnableToConnect$str() {
        return "SRMSG00106: Unable to connect stream `%s` (%s) - several publishers are available (%d), use the @Merge annotation to indicate the merge strategy.";
    }
    @Override
    public final String weavingUnableToConnect(final String source, final String method, final int number) {
        return String.format(getLoggingLocale(), weavingUnableToConnect$str(), source, method, number);
    }
    protected String actionNotProvided$str() {
        return "SRMSG00107: Action to execute not provided";
    }
    @Override
    public final String actionNotProvided() {
        return String.format(getLoggingLocale(), actionNotProvided$str());
    }
    protected String workerNameNotSpecified$str() {
        return "SRMSG00108: Worker Name not specified";
    }
    @Override
    public final String workerNameNotSpecified() {
        return String.format(getLoggingLocale(), workerNameNotSpecified$str());
    }
    protected String methodWasEmpty$str() {
        return "SRMSG00109: Method was empty";
    }
    @Override
    public final String methodWasEmpty() {
        return String.format(getLoggingLocale(), methodWasEmpty$str());
    }
    protected String classNameWasEmpty$str() {
        return "SRMSG00110: className was empty";
    }
    @Override
    public final String classNameWasEmpty() {
        return String.format(getLoggingLocale(), classNameWasEmpty$str());
    }
    protected String annotatedTypeWasEmpty$str() {
        return "SRMSG00111: AnnotatedType was empty";
    }
    @Override
    public final String annotatedTypeWasEmpty() {
        return String.format(getLoggingLocale(), annotatedTypeWasEmpty$str());
    }
    protected String isNull$str() {
        return "SRMSG00113: %s is null";
    }
    @Override
    public final String isNull(final String name) {
        return String.format(getLoggingLocale(), isNull$str(), name);
    }
    protected String prefixMustNotBeSet$str() {
        return "SRMSG00117: the prefix must not be set";
    }
    @Override
    public final String prefixMustNotBeSet() {
        return String.format(getLoggingLocale(), prefixMustNotBeSet$str());
    }
    protected String configMustNotBeSet$str() {
        return "SRMSG00118: the config must not be set";
    }
    @Override
    public final String configMustNotBeSet() {
        return String.format(getLoggingLocale(), configMustNotBeSet$str());
    }
    protected String channelMustNotBeSet$str() {
        return "SRMSG00119: the channel name must be set";
    }
    @Override
    public final String channelMustNotBeSet() {
        return String.format(getLoggingLocale(), channelMustNotBeSet$str());
    }
    protected String streamMustBeSet$str() {
        return "SRMSG00120: 'stream' must be set";
    }
    @Override
    public final String streamMustBeSet() {
        return String.format(getLoggingLocale(), streamMustBeSet$str());
    }
    protected String subscriberMustBeSet$str() {
        return "SRMSG00121: 'subscriber' must be set";
    }
    @Override
    public final String subscriberMustBeSet() {
        return String.format(getLoggingLocale(), subscriberMustBeSet$str());
    }
    protected String emitterMustBeSet$str() {
        return "SRMSG00122: 'emitter' must be set";
    }
    @Override
    public final String emitterMustBeSet() {
        return String.format(getLoggingLocale(), emitterMustBeSet$str());
    }
    protected String methodMustBeSet$str() {
        return "SRMSG00123: 'method' must be set";
    }
    @Override
    public final String methodMustBeSet() {
        return String.format(getLoggingLocale(), methodMustBeSet$str());
    }
    protected String beanMustBeSet$str() {
        return "SRMSG00124: 'bean' must be set";
    }
    @Override
    public final String beanMustBeSet() {
        return String.format(getLoggingLocale(), beanMustBeSet$str());
    }
}
