/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.tracing;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.smallrye.reactive.messaging.TracingMetadata;
import io.smallrye.reactive.messaging.providers.MetadataInjectableMessage;
import java.util.Optional;
import org.eclipse.microprofile.reactive.messaging.Message;

public class TracingUtils {
    private TracingUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void traceOutgoing(Instrumenter<T, Void> instrumenter, Message<?> message, T trace) {
        Optional tracingMetadata = TracingMetadata.fromMessage(message);
        Context parentContext = tracingMetadata.map(TracingMetadata::getCurrentContext).orElse(Context.current());
        Scope scope = null;
        boolean shouldStart = instrumenter.shouldStart(parentContext, trace);
        if (shouldStart) {
            try {
                Context spanContext = instrumenter.start(parentContext, trace);
                scope = spanContext.makeCurrent();
                instrumenter.end(spanContext, trace, null, null);
            }
            finally {
                if (scope != null) {
                    scope.close();
                }
            }
        }
    }

    public static <T> Message<?> traceIncoming(Instrumenter<T, Void> instrumenter, Message<?> msg, T trace) {
        return TracingUtils.traceIncoming(instrumenter, msg, trace, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Message<?> traceIncoming(Instrumenter<T, Void> instrumenter, Message<?> msg, T trace, boolean makeCurrent) {
        TracingMetadata tracingMetadata = TracingMetadata.fromMessage(msg).orElse(TracingMetadata.empty());
        Context parentContext = tracingMetadata.getPreviousContext();
        if (parentContext == null) {
            parentContext = Context.current();
        }
        Scope scope = null;
        boolean shouldStart = instrumenter.shouldStart(parentContext, trace);
        if (shouldStart) {
            Message<?> message;
            Context spanContext = instrumenter.start(parentContext, trace);
            if (makeCurrent) {
                scope = spanContext.makeCurrent();
            }
            TracingMetadata newTracingMetadata = TracingMetadata.with((Context)spanContext, (Context)parentContext);
            if (msg instanceof MetadataInjectableMessage) {
                ((MetadataInjectableMessage)msg).injectMetadata((Object)newTracingMetadata);
                message = msg;
            } else {
                message = msg.addMetadata((Object)newTracingMetadata);
            }
            try {
                instrumenter.end(spanContext, trace, null, null);
            }
            finally {
                if (scope != null) {
                    scope.close();
                }
            }
            return message;
        }
        return msg;
    }
}

