/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt.session;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.smallrye.reactive.messaging.mqtt.session.MqttClientSessionOptions;
import io.smallrye.reactive.messaging.mqtt.session.RequestedQoS;
import io.smallrye.reactive.messaging.mqtt.session.SessionEvent;
import io.smallrye.reactive.messaging.mqtt.session.SessionState;
import io.smallrye.reactive.messaging.mqtt.session.SubscriptionEvent;
import io.smallrye.reactive.messaging.mqtt.session.SubscriptionState;
import io.smallrye.reactive.messaging.mqtt.session.impl.MqttClientSessionImpl;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.mqtt.messages.MqttPublishMessage;

@VertxGen
public interface MqttClientSession {
    public static MqttClientSession create(Vertx vertx, MqttClientSessionOptions options) {
        return new MqttClientSessionImpl(vertx, options);
    }

    @Fluent
    public MqttClientSession sessionStateHandler(Handler<SessionEvent> var1);

    @Fluent
    public MqttClientSession subscriptionStateHandler(Handler<SubscriptionEvent> var1);

    @Fluent
    public MqttClientSession publishCompletionHandler(Handler<Integer> var1);

    @Fluent
    public MqttClientSession publishCompletionExpirationHandler(Handler<Integer> var1);

    @Fluent
    public MqttClientSession publishCompletionUnknownPacketIdHandler(Handler<Integer> var1);

    public Future<Void> start();

    public Future<Void> stop();

    public SessionState getState();

    public SubscriptionState getSubscriptionState(String var1);

    default public boolean isConnected() {
        return this.getState() == SessionState.CONNECTED;
    }

    public Future<Integer> subscribe(String var1, RequestedQoS var2);

    public Future<Void> unsubscribe(String var1);

    @Fluent
    public MqttClientSession messageHandler(Handler<MqttPublishMessage> var1);

    @Fluent
    public MqttClientSession exceptionHandler(Handler<Throwable> var1);

    public Future<Integer> publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5);

    default public Future<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel) {
        return this.publish(topic, payload, qosLevel, false, false);
    }
}

