/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.jms;

import io.smallrye.reactive.messaging.jms.i18n.JmsLogging;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import java.util.function.Function;
import java.util.function.Supplier;

public class JmsResourceHolder<T>
implements ExceptionListener {
    private final String channel;
    private final Supplier<JMSContext> contextCreator;
    private Function<JmsResourceHolder<T>, Destination> destinationCreator;
    private Function<JmsResourceHolder<T>, T> clientCreator;
    private volatile JMSContext context;
    private volatile Destination destination;
    private volatile T client;
    private volatile boolean closed = false;

    public JmsResourceHolder(String channel, Supplier<JMSContext> contextCreator) {
        this.channel = channel;
        this.contextCreator = contextCreator;
    }

    public JmsResourceHolder<T> configure(Function<JmsResourceHolder<T>, Destination> destinationCreator, Function<JmsResourceHolder<T>, T> clientCreator) {
        this.destinationCreator = destinationCreator;
        this.clientCreator = clientCreator;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination() {
        if (this.destination == null) {
            JmsResourceHolder jmsResourceHolder = this;
            synchronized (jmsResourceHolder) {
                if (this.destination == null) {
                    this.destination = this.destinationCreator.apply(this);
                }
            }
        }
        return this.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getClient() {
        if (this.client == null) {
            JmsResourceHolder jmsResourceHolder = this;
            synchronized (jmsResourceHolder) {
                if (this.client == null) {
                    this.client = this.clientCreator.apply(this);
                }
            }
        }
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSContext getContext() {
        if (this.context == null) {
            JmsResourceHolder jmsResourceHolder = this;
            synchronized (jmsResourceHolder) {
                if (this.context == null) {
                    this.context = this.contextCreator.get();
                    this.closed = false;
                    this.context.setExceptionListener((ExceptionListener)this);
                }
            }
        }
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException exception) {
        JmsResourceHolder jmsResourceHolder = this;
        synchronized (jmsResourceHolder) {
            if (this.closed) {
                return;
            }
            JmsLogging.log.jmsException(this.channel, exception);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        JmsResourceHolder jmsResourceHolder = this;
        synchronized (jmsResourceHolder) {
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            this.destination = null;
            if (this.client != null) {
                if (this.client instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)this.client).close();
                    }
                    catch (Exception e) {
                        JmsLogging.log.infof(e, "Error closing client for channel %s", this.channel);
                    }
                }
                this.client = null;
            }
            this.closed = true;
        }
    }
}

