/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.jms;

import io.smallrye.reactive.messaging.jms.JmsMessageMetadata;
import io.smallrye.reactive.messaging.jms.JmsProperties;
import io.smallrye.reactive.messaging.jms.impl.ImmutableJmsProperties;
import io.smallrye.reactive.messaging.jms.impl.Wrap;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import java.util.Enumeration;

public class IncomingJmsMessageMetadata
implements JmsMessageMetadata,
JmsProperties {
    private final Message message;
    private final ImmutableJmsProperties properties;

    public IncomingJmsMessageMetadata(Message incoming) {
        this.message = incoming;
        this.properties = new ImmutableJmsProperties(incoming);
    }

    public String getMessageId() {
        return Wrap.wrap(() -> ((Message)this.message).getJMSMessageID());
    }

    public long getTimestamp() {
        return Wrap.wrap(() -> ((Message)this.message).getJMSTimestamp());
    }

    @Override
    public String getCorrelationId() {
        return Wrap.wrap(() -> ((Message)this.message).getJMSCorrelationID());
    }

    @Override
    public Destination getReplyTo() {
        return Wrap.wrap(() -> ((Message)this.message).getJMSReplyTo());
    }

    @Override
    public Destination getDestination() {
        return Wrap.wrap(() -> ((Message)this.message).getJMSDestination());
    }

    @Override
    public int getDeliveryMode() {
        return Wrap.wrap(() -> ((Message)this.message).getJMSDeliveryMode());
    }

    public boolean isRedelivered() {
        return Wrap.wrap(() -> ((Message)this.message).getJMSRedelivered());
    }

    @Override
    public String getType() {
        return Wrap.wrap(() -> ((Message)this.message).getJMSType());
    }

    @Override
    public JmsProperties getProperties() {
        return this.properties;
    }

    public long getExpiration() {
        return Wrap.wrap(() -> ((Message)this.message).getJMSExpiration());
    }

    public long getDeliveryTime() {
        return Wrap.wrap(() -> ((Message)this.message).getJMSDeliveryTime());
    }

    public int getPriority() {
        return Wrap.wrap(() -> ((Message)this.message).getJMSPriority());
    }

    @Override
    public boolean propertyExists(String name) {
        return this.properties.propertyExists(name);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        return this.properties.getBooleanProperty(name);
    }

    @Override
    public byte getByteProperty(String name) {
        return this.properties.getByteProperty(name);
    }

    @Override
    public short getShortProperty(String name) {
        return this.properties.getShortProperty(name);
    }

    @Override
    public int getIntProperty(String name) {
        return this.properties.getIntProperty(name);
    }

    @Override
    public long getLongProperty(String name) {
        return this.properties.getLongProperty(name);
    }

    @Override
    public float getFloatProperty(String name) {
        return this.properties.getFloatProperty(name);
    }

    @Override
    public double getDoubleProperty(String name) {
        return this.properties.getDoubleProperty(name);
    }

    @Override
    public String getStringProperty(String name) {
        return this.properties.getStringProperty(name);
    }

    @Override
    public Object getObjectProperty(String name) {
        return this.properties.getObjectProperty(name);
    }

    @Override
    public Enumeration<String> getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public <X> X getBody(Class<X> c) {
        return (X)Wrap.wrap(() -> this.message.getBody(c));
    }

    public boolean isBodyAssignableTo(Class<?> c) {
        return Wrap.wrap(() -> this.message.isBodyAssignableTo(c));
    }
}

