package io.vertx.mutiny.ext.web;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A web user is extended user coupled to the context and is used to perform verifications
 * and actions on behalf of the user. Actions can be:
 *
 * <ul>
 *   <li>{@link io.vertx.mutiny.ext.web.UserContext#impersonate} - Require a re-authentication to switch user identities</li>
 *   <li>{@link io.vertx.mutiny.ext.web.UserContext#restore} - De-escalate a previous impersonate call</li>
 *   <li>{@link io.vertx.mutiny.ext.web.UserContext#logout} - Logout the user from this application and redirect to a uri</li>
 *   <li>{@link io.vertx.mutiny.ext.web.UserContext#clear} - Same as logout, without requirind a redirect</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.UserContext original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.UserContext.class)
public class UserContext implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<UserContext> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new UserContext((io.vertx.ext.web.UserContext) obj),
    UserContext::getDelegate
  );

  private final io.vertx.ext.web.UserContext delegate;
  
  public UserContext(io.vertx.ext.web.UserContext delegate) {
    this.delegate = delegate;
  }

  public UserContext(Object delegate) {
    this.delegate = (io.vertx.ext.web.UserContext)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  UserContext() {
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.web.UserContext getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UserContext that = (UserContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the user, or null if the current user is not authenticated.
   */
  public io.vertx.mutiny.ext.auth.User get() { 
    io.vertx.mutiny.ext.auth.User ret = io.vertx.mutiny.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.get());
    return ret;
  }

  public boolean authenticated() { 
    boolean ret = delegate.authenticated();
    return ret;
  }

  /**
   * @param loginHint the desired login name, for example: <code>admin</code>.
   * @return fluent self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.UserContext loginHint(String loginHint) { 
    delegate.loginHint(loginHint);
    return this;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> impersonate() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(callback -> {
        delegate.impersonate(callback);
    });
  }

  public Void impersonateAndAwait() { 
    return (Void) impersonate().await().indefinitely();
  }

  public void impersonateAndForget() { 
    impersonate().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> impersonate(String redirectUri) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(callback -> {
        delegate.impersonate(redirectUri, callback);
    });
  }

  public Void impersonateAndAwait(String redirectUri) { 
    return (Void) impersonate(redirectUri).await().indefinitely();
  }

  public void impersonateAndForget(String redirectUri) { 
    impersonate(redirectUri).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> restore() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(callback -> {
        delegate.restore(callback);
    });
  }

  public Void restoreAndAwait() { 
    return (Void) restore().await().indefinitely();
  }

  public void restoreAndForget() { 
    restore().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> restore(String redirectUri) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(callback -> {
        delegate.restore(redirectUri, callback);
    });
  }

  public Void restoreAndAwait(String redirectUri) { 
    return (Void) restore(redirectUri).await().indefinitely();
  }

  public void restoreAndForget(String redirectUri) { 
    restore(redirectUri).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> logout(String redirectUri) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(callback -> {
        delegate.logout(redirectUri, callback);
    });
  }

  public Void logoutAndAwait(String redirectUri) { 
    return (Void) logout(redirectUri).await().indefinitely();
  }

  public void logoutAndForget(String redirectUri) { 
    logout(redirectUri).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> logout() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(callback -> {
        delegate.logout(callback);
    });
  }

  public Void logoutAndAwait() { 
    return (Void) logout().await().indefinitely();
  }

  public void logoutAndForget() { 
    logout().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   */
  public void clear() { 
    delegate.clear();
  }

  public static  UserContext newInstance(io.vertx.ext.web.UserContext arg) {
    return arg != null ? new UserContext(arg) : null;
  }

}
